/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.strategy;

import com.liferay.data.engine.rest.internal.strategy.MapToDDMFormValuesConverterStrategy;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class DefaultMapToDDMFormValuesConverterStrategy
implements MapToDDMFormValuesConverterStrategy {
    private static DefaultMapToDDMFormValuesConverterStrategy _defaultMapToDDMFormValuesConverterStrategy = new DefaultMapToDDMFormValuesConverterStrategy();

    public static DefaultMapToDDMFormValuesConverterStrategy getInstance() {
        return _defaultMapToDDMFormValuesConverterStrategy;
    }

    @Override
    public void setDDMFormFieldValues(Map<String, Object> dataRecordValues, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : ddmFormFields.entrySet()) {
            if (!dataRecordValues.containsKey(entry.getKey())) continue;
            List<DDMFormFieldValue> ddmFormFieldValues = this.createDDMFormFieldValues(dataRecordValues, (DDMFormField)entry.getValue(), ddmForm.getDefaultLocale(), locale);
            Stream stream = ddmFormFieldValues.stream();
            stream.forEach(arg_0 -> ((DDMFormValues)ddmFormValues).addDDMFormFieldValue(arg_0));
        }
    }

    protected List<DDMFormFieldValue> createDDMFormFieldValues(Map<String, Object> dataRecordValues, final DDMFormField ddmFormField, Locale defaultLocale, Locale locale) {
        if (dataRecordValues == null || !dataRecordValues.containsKey(ddmFormField.getName())) {
            return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{new DDMFormFieldValue(){
                {
                    this.setName(ddmFormField.getName());
                }
            }});
        }
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            if (ListUtil.isEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{new DDMFormFieldValue(){
                    {
                        this.setName(ddmFormField.getName());
                    }
                }});
            }
            Map fieldSetInstanceValues = (Map)dataRecordValues.get(ddmFormField.getName());
            ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>(fieldSetInstanceValues.size());
            for (final Map.Entry entry : fieldSetInstanceValues.entrySet()) {
                DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                    {
                        this.setName(ddmFormField.getName());
                        this.setInstanceId((String)entry.getKey());
                    }
                };
                for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                    List<DDMFormFieldValue> nestedDDMFormFieldValues = this.createDDMFormFieldValues((Map)fieldSetInstanceValues.get(ddmFormFieldValue.getInstanceId()), nestedDDMFormField, defaultLocale, locale);
                    Stream stream = nestedDDMFormFieldValues.stream();
                    stream.forEach(arg_0 -> ((DDMFormFieldValue)ddmFormFieldValue).addNestedDDMFormFieldValue(arg_0));
                }
                ddmFormFieldValues.add(ddmFormFieldValue);
            }
            return ddmFormFieldValues;
        }
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
            {
                this.setName(ddmFormField.getName());
                this.setValue((Value)ddmFormField.getPredefinedValue());
            }
        };
        if (ddmFormField.isRepeatable()) {
            List list = null;
            if (ddmFormField.isLocalizable()) {
                Object value = dataRecordValues.get(ddmFormField.getName());
                if (!(value instanceof Map)) {
                    throw new IllegalArgumentException("Field value is not a map");
                }
                Map localizedValues = (Map)value;
                list = (List)localizedValues.get(LanguageUtil.getLanguageId((Locale)((Locale)GetterUtil.getObject((Object)locale, (Object)defaultLocale))));
            } else {
                list = (List)dataRecordValues.get(ddmFormField.getName());
            }
            if (list == null) {
                return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{ddmFormFieldValue});
            }
            ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>(list.size());
            for (Object object : list) {
                ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setName(ddmFormField.getName());
                LocalizedValue localizedValue = new LocalizedValue();
                localizedValue.addString((Locale)GetterUtil.getObject((Object)locale, (Object)defaultLocale), String.valueOf(object));
                ddmFormFieldValue.setValue((Value)localizedValue);
                ddmFormFieldValues.add(ddmFormFieldValue);
            }
            return ddmFormFieldValues;
        }
        if (dataRecordValues.get(ddmFormField.getName()) != null) {
            ddmFormFieldValue.setValue(this.createValue(ddmFormField, locale, dataRecordValues.get(ddmFormField.getName())));
        }
        return ListUtil.fromArray((Object[])new DDMFormFieldValue[]{ddmFormFieldValue});
    }

    private DefaultMapToDDMFormValuesConverterStrategy() {
    }
}

