/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.data.engine.rest.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.MapToDDMFormValuesConverterUtil;
import com.liferay.data.engine.rest.internal.storage.util.DataStorageUtil;
import com.liferay.data.engine.storage.DataStorage;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"data.storage.type=json"}, service={DataStorage.class})
public class JSONDataStorage
implements DataStorage {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMContentLocalService _ddmContentLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private Portal _portal;

    public long delete(long dataStorageId) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.fetchDDMContent(dataStorageId);
        if (ddmContent != null) {
            this._ddmContentLocalService.deleteDDMContent(ddmContent);
        }
        return dataStorageId;
    }

    public Map<String, Object> get(long dataDefinitionId, long dataStorageId) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.getContent(dataStorageId);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        return DataStorageUtil.toDataRecordValues(this._deserializeDDMFormValues(ddmContent.getData(), ddmStructure.getFullHierarchyDDMForm()), ddmStructure);
    }

    public long save(long dataRecordCollectionId, Map<String, Object> dataRecordValues, final long siteId) throws Exception {
        DataRecordCollection dataRecordCollection = DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId));
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataRecordCollection.getDataDefinitionId().longValue());
        DDMContent ddmContent = this._ddmContentLocalService.addContent(PrincipalThreadLocal.getUserId(), siteId, DataRecord.class.getName(), null, this._serializeDDMFormValues(MapToDDMFormValuesConverterUtil.toDDMFormValues(dataRecordValues, ddmStructure.getFullHierarchyDDMForm(), null)), new ServiceContext(){
            {
                this.setScopeGroupId(siteId);
                this.setUserId(PrincipalThreadLocal.getUserId());
            }
        });
        return ddmContent.getPrimaryKey();
    }

    private DDMFormValues _deserializeDDMFormValues(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    private String _serializeDDMFormValues(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }
}

