/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordValuesUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.stream.Stream;

public class DataRecordExporter {
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    public DataRecordExporter(DDLRecordSetLocalService ddlRecordSetLocalService, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, SPIDDMFormRuleConverter spiDDMFormRuleConverter) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._spiDDMFormRuleConverter = spiDDMFormRuleConverter;
    }

    public String export(List<DataRecord> dataRecords) throws Exception {
        if (ListUtil.isEmpty(dataRecords)) {
            return "";
        }
        DataRecord dataRecord = dataRecords.get(0);
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecord.getDataRecordCollectionId().longValue());
        DataDefinition dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddlRecordSet.getDDMStructure(), this._spiDDMFormRuleConverter);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Stream stream = dataRecords.parallelStream();
        stream.map(record -> this._toJSON(dataDefinition, (DataRecord)record)).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toString();
    }

    private String _toJSON(DataDefinition dataDefinition, DataRecord dataRecord) {
        try {
            return DataRecordValuesUtil.toJSON(dataDefinition, dataRecord.getDataRecordValues());
        }
        catch (Exception exception) {
            return "";
        }
    }
}

