/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.model.DEDataDefinitionFieldLinkModel;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.nativeobject.DataEngineNativeObject;
import com.liferay.data.engine.nativeobject.DataEngineNativeObjectField;
import com.liferay.data.engine.nativeobject.tracker.DataEngineNativeObjectTracker;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRow;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.dynamic.data.mapping.util.comparator.StructureCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl
implements EntityModelResource {
    private static final String[] _BASIC_FIELD_TYPES = new String[]{"date", "numeric", "radio", "select", "text"};
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionResourceImpl.class);
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DataEngineNativeObjectTracker _dataEngineNativeObjectTracker;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMFormRuleDeserializer _ddmFormRuleDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _ddmFormSerializer;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMFormValidator _ddmFormValidator;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "DELETE");
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(dataDefinitionId.longValue());
        for (DEDataDefinitionFieldLink deDataDefinitionFieldLink : this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(dataDefinitionId.longValue())) {
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLink(deDataDefinitionFieldLink);
            if (deDataDefinitionFieldLink.getClassNameId() != this._portal.getClassNameId(DDMStructure.class)) continue;
            DataDefinition dataDefinition = this._toDataDefinition(this._ddmStructureLocalService.getStructure(deDataDefinitionFieldLink.getClassPK()));
            this._removeFieldsFromDataLayoutsAndDataListViews(dataDefinition, deDataDefinitionFieldLink.getClassPK(), new String[]{deDataDefinitionFieldLink.getFieldName()});
            dataDefinition.setDataDefinitionFields((DataDefinitionField[])ArrayUtil.filter((Object[])dataDefinition.getDataDefinitionFields(), dataDefinitionField -> !StringUtil.equals((String)dataDefinitionField.getName(), (String)deDataDefinitionFieldLink.getFieldName())));
            this._updateDataDefinition(dataDefinition, dataDefinition.getId(), DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker));
        }
        this._deDataListViewLocalService.deleteDEDataListViews(dataDefinitionId.longValue());
        this._ddmStructureLocalService.deleteStructure(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()), this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getDataDefinitionByContentTypeContentTypePage(String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteDataDefinitionByContentTypeContentTypePage(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, keywords, pagination, sorts);
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Set ddmFormFieldTypeNames = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames();
        Stream stream = ddmFormFieldTypeNames.stream();
        stream.map(ddmFormFieldTypeName -> this._getFieldTypeMetadataJSONObject((String)ddmFormFieldTypeName, this._getResourceBundle((String)ddmFormFieldTypeName, this.contextAcceptLanguage.getPreferredLocale()))).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toJSONString();
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldLinks(Long dataDefinitionId, String fieldName) throws Exception {
        return JSONUtil.put((String)"dataLayouts", this.transformToArray(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId.longValue(), fieldName), deDataDefinitionFieldLink -> {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getDDMStructureLayout(deDataDefinitionFieldLink.getClassPK());
            return ddmStructureLayout.getName(ddmStructureLayout.getDefaultLanguageId());
        }, String.class)).put("dataListViews", this.transformToArray(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId.longValue(), fieldName), deDataDefinitionFieldLink -> {
            DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(deDataDefinitionFieldLink.getClassPK());
            return deDataListView.getName(deDataListView.getDefaultLanguageId());
        }, String.class)).toString();
    }

    @Override
    public Page<Permission> getDataDefinitionPermissionsPage(Long dataDefinitionId, String roleNames) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataDefinitionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataDefinition getSiteDataDefinitionByContentTypeByDataDefinitionKey(Long siteId, String contentType, String dataDefinitionKey) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), dataDefinitionKey), this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionByContentTypeContentTypePage(Long siteId, String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (Objects.equals(contentType, "native-object") && Validator.isNull((String)keywords)) {
            for (final DataEngineNativeObject dataEngineNativeObject : this._dataEngineNativeObjectTracker.getDataEngineNativeObjects()) {
                DataDefinition dataDefinition = null;
                try {
                    dataDefinition = this.getSiteDataDefinitionByContentTypeByDataDefinitionKey(siteId, "native-object", dataEngineNativeObject.getClassName());
                }
                catch (Exception exception) {
                    if (!(exception instanceof NoSuchStructureException) && !(exception.getCause() instanceof NoSuchStructureException)) {
                        throw exception;
                    }
                    dataDefinition = new DataDefinition(){
                        {
                            this.availableLanguageIds = new String[]{DataDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId()};
                            this.dataDefinitionKey = dataEngineNativeObject.getClassName();
                            this.storageType = "json";
                        }
                    };
                }
                dataDefinition.setDataDefinitionFields(this._toDataDefinitionFields(Optional.ofNullable(dataDefinition.getDataDefinitionFields()).orElse(new DataDefinitionField[0]), dataEngineNativeObject.getDataEngineNativeObjectFields()));
                dataDefinition.setName((Map)HashMapBuilder.putAll((Map)Optional.ofNullable(dataDefinition.getName()).orElse(new HashMap())).put((Object)this.contextAcceptLanguage.getPreferredLanguageId(), (Object)dataEngineNativeObject.getName()).build());
                if (Validator.isNull((Long)dataDefinition.getId())) {
                    this.postDataDefinitionByContentType("native-object", dataDefinition);
                    continue;
                }
                this.putDataDefinition(dataDefinition.getId(), dataDefinition);
            }
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLocalService.getStructures(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataDefinition), (Pagination)pagination, (long)this._ddmStructureLocalService.getStructuresCount(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, DDMStructure.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"classNameId", "entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)this._dataDefinitionContentTypeTracker.getClassNameId(contentType));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)document.get("entryClassPK"))), this._spiDDMFormRuleConverter));
    }

    @Override
    public DataDefinition postDataDefinitionByContentType(String contentType, DataDefinition dataDefinition) throws Exception {
        return this.postSiteDataDefinitionByContentType(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, dataDefinition);
    }

    @Override
    public DataDefinition postSiteDataDefinitionByContentType(Long siteId, String contentType, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), contentType, (long)siteId, "ADD_DATA_DEFINITION");
        DDMForm ddmForm = DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker);
        this._validate(dataDefinition, ddmForm);
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        final DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), GetterUtil.getString((String)dataDefinition.getStorageType(), (String)"json"), new ServiceContext());
        this._addDataDefinitionFieldLinks(ddmStructure.getStructureId(), ddmForm.getDDMFormFields(), ddmStructure.getGroupId());
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            dataLayout.setDataLayoutKey(ddmStructure.getStructureKey());
            if (Validator.isNull((Object)dataLayout.getName())) {
                dataLayout.setName(dataDefinition.getName());
            }
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            dataDefinition.setDefaultDataLayout(dataLayoutResource.postDataDefinitionDataLayout(Long.valueOf(ddmStructure.getStructureId()), dataLayout));
        }
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddmStructure, this._spiDDMFormRuleConverter);
        this._resourceLocalService.addResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue()), DDMStructure.class.getName()}), dataDefinition.getId().longValue(), false, false, false);
        DataRecordCollectionResource dataRecordCollectionResource = this._getDataRecordCollectionResource(false);
        dataRecordCollectionResource.postDataDefinitionDataRecordCollection(dataDefinition.getId(), new DataRecordCollection(){
            {
                this.setDataDefinitionId(ddmStructure.getStructureId());
                this.setDataRecordCollectionKey(ddmStructure.getStructureKey());
                this.setDescription(LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap()));
                this.setName(LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap()));
            }
        });
        return dataDefinition;
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "UPDATE");
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            dataDefinition.setDefaultDataLayout(dataLayoutResource.putDataLayout(Optional.ofNullable(dataLayout.getId()).orElse(this._getDefaultDataLayoutId(dataDefinitionId)), dataLayout));
        }
        DDMForm ddmForm = DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker);
        this._validate(dataDefinition, ddmForm);
        this._removeFieldsFromDataLayoutsAndDataListViews(dataDefinition, dataDefinitionId, this._getRemovedFieldNames(dataDefinition, dataDefinitionId));
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        this._addDataDefinitionFieldLinks(dataDefinitionId, ddmForm.getDDMFormFields(), Optional.ofNullable(dataDefinition.getSiteId()).orElse(this.getPermissionCheckerGroupId(dataDefinitionId)));
        return this._updateDataDefinition(dataDefinition, dataDefinitionId, ddmForm);
    }

    @Override
    public void putDataDefinitionPermission(Long dataDefinitionId, Permission[] permissions) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(dataDefinitionId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)dataDefinitionId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ddmStructure.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDMStructure.class.getName()});
    }

    private void _addDataDefinitionFieldLinks(long dataDefinitionId, List<DDMFormField> ddmFormFields, long groupId) throws Exception {
        for (DDMFormField ddmFormField : ddmFormFields) {
            Long fieldSetDDMStructureId = GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureId"));
            if (!Validator.isNotNull((Long)fieldSetDDMStructureId)) continue;
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(groupId, this._portal.getClassNameId(DDMStructure.class), dataDefinitionId, fieldSetDDMStructureId.longValue(), ddmFormField.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _createFieldContextJSONObject(DDMFormFieldType ddmFormFieldType, Locale locale, String type) {
        Locale originalThemeDisplayLocale = LocaleThreadLocal.getThemeDisplayLocale();
        LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
        try {
            DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
            DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
            ddmFormRenderingContext.setContainerId("settings");
            DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create(this.contextHttpServletRequest, ddmFormFieldTypeSettingsDDMForm);
            this._setTypeDDMFormFieldValue(ddmFormValues, type);
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
            ddmFormRenderingContext.setHttpServletRequest(this.contextHttpServletRequest);
            ddmFormRenderingContext.setLocale(locale);
            ddmFormRenderingContext.setPortletNamespace(this._portal.getPortletNamespace(this._portal.getPortletId(this.contextHttpServletRequest)));
            ddmFormRenderingContext.setReturnFullContext(true);
            JSONObject jSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerializeDeep((Object)this._ddmFormTemplateContextFactory.create(ddmFormFieldTypeSettingsDDMForm, DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings()), ddmFormRenderingContext)));
            return jSONObject;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        finally {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)originalThemeDisplayLocale);
        }
        return null;
    }

    private DataLayoutResource _getDataLayoutResource(boolean checkPermission) {
        DataLayoutResource.Builder builder = DataLayoutResource.builder();
        return builder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private DataRecordCollectionResource _getDataRecordCollectionResource(boolean checkPermission) {
        DataRecordCollectionResource.Builder builder = DataRecordCollectionResource.builder();
        return builder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private long _getDefaultDataLayoutId(long dataDefinitionId) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId);
        DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        DataLayout dataLayout = dataLayoutResource.getSiteDataLayoutByContentTypeByDataLayoutKey(Long.valueOf(ddmStructure.getGroupId()), dataDefinitionContentType.getContentType(), ddmStructure.getStructureKey());
        return dataLayout.getId();
    }

    private String _getFieldType(String customType, int sqlType) {
        if (ArrayUtil.contains((Object[])_BASIC_FIELD_TYPES, (Object)customType)) {
            return customType;
        }
        String type = "text";
        if (sqlType == 2003) {
            type = "select";
        } else if (sqlType == 16) {
            type = "radio";
        } else if (sqlType == -5 || sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 4 || sqlType == 2 || sqlType == -6) {
            type = "numeric";
        } else if (sqlType == 91) {
            type = "date";
        }
        return type;
    }

    private JSONObject _getFieldTypeMetadataJSONObject(String ddmFormFieldName, ResourceBundle resourceBundle) {
        Map ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeProperties(ddmFormFieldName);
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldName);
        return JSONUtil.put((String)"description", (Object)this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.description"), resourceBundle)).put("displayOrder", MapUtil.getInteger((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.display.order", (int)Integer.MAX_VALUE)).put("group", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.group")).put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon")).put("javaScriptModule", this._resolveModuleName(ddmFormFieldType)).put("label", this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.label"), resourceBundle)).put("name", ddmFormFieldName).put("scope", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.scope")).put("settingsContext", this._createFieldContextJSONObject(ddmFormFieldType, this.contextAcceptLanguage.getPreferredLocale(), ddmFormFieldName)).put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
    }

    private String[] _getRemovedFieldNames(DataDefinition dataDefinition, long dataDefinitionId) throws Exception {
        DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(dataDefinitionId), this._spiDDMFormRuleConverter);
        return (String[])ArrayUtil.filter((Object[])this.transform(existingDataDefinition.getDataDefinitionFields(), DataDefinitionField::getName, String.class), fieldName -> !ArrayUtil.contains((Object[])this.transform(dataDefinition.getDataDefinitionFields(), DataDefinitionField::getName, String.class), (Object)fieldName));
    }

    private ResourceBundle _getResourceBundle(String ddmFormFieldTypeName, Locale locale) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldTypeName);
        return new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ddmFormFieldType.getClass()), this._portal.getResourceBundle(locale)});
    }

    private void _removeFieldsFromDataLayout(DataLayout dataLayout, String[] fieldNames) {
        Stream<DataLayoutPage> dataLayoutPages = Arrays.stream(dataLayout.getDataLayoutPages());
        dataLayoutPages.forEach(dataLayoutPage -> {
            Stream<DataLayoutRow> dataLayoutRows = Arrays.stream(dataLayoutPage.getDataLayoutRows());
            dataLayoutRows.forEach(dataLayoutRow -> {
                Stream<DataLayoutColumn> dataLayoutColumns = Arrays.stream(dataLayoutRow.getDataLayoutColumns());
                dataLayoutColumns.forEach(dataLayoutColumn -> dataLayoutColumn.setFieldNames((String[])ArrayUtil.filter((Object[])dataLayoutColumn.getFieldNames(), fieldName -> !ArrayUtil.contains((Object[])fieldNames, (Object)fieldName))));
                dataLayoutRow.setDataLayoutColumns((DataLayoutColumn[])ArrayUtil.filter((Object[])dataLayoutRow.getDataLayoutColumns(), column -> !ArrayUtil.isEmpty((Object[])column.getFieldNames())));
            });
            dataLayoutPage.setDataLayoutRows((DataLayoutRow[])ArrayUtil.filter((Object[])dataLayoutPage.getDataLayoutRows(), row -> !ArrayUtil.isEmpty((Object[])row.getDataLayoutColumns())));
        });
    }

    private void _removeFieldsFromDataLayouts(DataDefinition dataDefinition, Set<Long> ddmStructureLayoutIds, String[] fieldNames) throws Exception {
        for (Long ddmStructureLayoutId : ddmStructureLayoutIds) {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(ddmStructureLayoutId.longValue());
            DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDDMFormLayout(), this._spiDDMFormRuleConverter);
            this._removeFieldsFromDataLayout(dataLayout, fieldNames);
            DDMFormLayout ddmFormLayout = DataLayoutUtil.toDDMFormLayout(dataLayout, DataDefinitionUtil.toDDMForm(dataDefinition, this._ddmFormFieldTypeServicesTracker), this._ddmFormRuleDeserializer);
            DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
            DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
            ddmStructureLayout.setDefinition(ddmFormLayoutSerializerSerializeResponse.getContent());
            this._ddmStructureLayoutLocalService.updateDDMStructureLayout(ddmStructureLayout);
        }
    }

    private void _removeFieldsFromDataLayoutsAndDataListViews(DataDefinition dataDefinition, long dataDefinitionId, String[] fieldNames) throws Exception {
        HashSet<Long> ddmStructureLayoutIds = new HashSet<Long>();
        HashSet<Long> deDataListViewIds = new HashSet<Long>();
        ddmStructureLayoutIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        deDataListViewIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames);
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames);
        this._removeFieldsFromDataLayouts(dataDefinition, ddmStructureLayoutIds, fieldNames);
        this._removeFieldsFromDataListViews(deDataListViewIds, fieldNames);
    }

    private void _removeFieldsFromDataListViews(Set<Long> deDataListViewIds, String[] removedFieldNames) throws Exception {
        for (Long deDataListViewId : deDataListViewIds) {
            DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(deDataListViewId.longValue());
            deDataListView.setFieldNames(Arrays.toString(ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray(deDataListView.getFieldNames())), fieldName -> !ArrayUtil.contains((Object[])removedFieldNames, (Object)fieldName))));
            this._deDataListViewLocalService.updateDEDataListView(deDataListView);
        }
    }

    private String _resolveModuleName(DDMFormFieldType ddmFormFieldType) {
        if (Validator.isNull((String)ddmFormFieldType.getModuleName())) {
            return "";
        }
        if (ddmFormFieldType.isCustomDDMFormFieldType()) {
            return ddmFormFieldType.getModuleName();
        }
        return this._npmResolver.resolveModuleName(ddmFormFieldType.getModuleName());
    }

    private void _setTypeDDMFormFieldValue(DDMFormValues ddmFormValues, String type) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("type");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(type));
    }

    private DataDefinition _toDataDefinition(DDMStructure ddmStructure) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, ddmStructure, this._spiDDMFormRuleConverter);
    }

    private DataDefinitionField[] _toDataDefinitionFields(DataDefinitionField[] dataDefinitionFields, List<DataEngineNativeObjectField> dataEngineNativeObjectFields) throws Exception {
        if (ListUtil.isEmpty(dataEngineNativeObjectFields)) {
            return new DataDefinitionField[0];
        }
        ArrayList<DataDefinitionField> list = new ArrayList<DataDefinitionField>();
        for (DataEngineNativeObjectField dataEngineNativeObjectField : dataEngineNativeObjectFields) {
            final Column column = dataEngineNativeObjectField.getColumn();
            DataDefinitionField dataDefinitionField = Stream.of(dataDefinitionFields).filter(field -> Objects.equals(column.getName(), field.getName())).findFirst().orElse(new DataDefinitionField(){
                {
                    this.customProperties = HashMapBuilder.put((Object)"native-field", (Object)"native-field").build();
                    this.label = HashMapBuilder.put((Object)DataDefinitionResourceImpl.this.contextAcceptLanguage.getPreferredLanguageId(), (Object)column.getName()).build();
                    this.name = column.getName();
                }
            });
            dataDefinitionField.setFieldType(this._getFieldType(dataEngineNativeObjectField.getCustomType(), column.getSQLType()));
            dataDefinitionField.setRequired(Boolean.valueOf(!column.isNullAllowed()));
            list.add(dataDefinitionField);
        }
        return list.toArray(new DataDefinitionField[0]);
    }

    private DataDefinitionValidationException _toDataDefinitionValidationException(DDMFormValidationException ddmFormValidationException) {
        if (ddmFormValidationException instanceof DDMFormValidationException.MustNotDuplicateFieldName) {
            DDMFormValidationException.MustNotDuplicateFieldName mustNotDuplicateFieldName = (DDMFormValidationException.MustNotDuplicateFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustNotDuplicateFieldName(mustNotDuplicateFieldName.getDuplicatedFieldNames());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetAvailableLocales) {
            return new DataDefinitionValidationException.MustSetAvailableLocales();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocale) {
            return new DataDefinitionValidationException.MustSetDefaultLocale();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale) {
            DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale mustSetDefaultLocaleAsAvailableLocale = (DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetDefaultLocaleAsAvailableLocale(mustSetDefaultLocaleAsAvailableLocale.getDefaultLocale());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldType) {
            DDMFormValidationException.MustSetFieldType mustSetFieldType = (DDMFormValidationException.MustSetFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetFieldType(mustSetFieldType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetOptionsForField) {
            DDMFormValidationException.MustSetOptionsForField mustSetOptionsForField = (DDMFormValidationException.MustSetOptionsForField)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetOptionsForField(mustSetOptionsForField.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidAvailableLocalesForProperty) {
            DDMFormValidationException.MustSetValidAvailableLocalesForProperty mustSetValidAvailableLocalesForProperty = (DDMFormValidationException.MustSetValidAvailableLocalesForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidAvailableLocalesForProperty(mustSetValidAvailableLocalesForProperty.getFieldName(), mustSetValidAvailableLocalesForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldName) {
            DDMFormValidationException.MustSetValidCharactersForFieldName mustSetValidCharactersForFieldName = (DDMFormValidationException.MustSetValidCharactersForFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldName(mustSetValidCharactersForFieldName.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldType) {
            DDMFormValidationException.MustSetValidCharactersForFieldType mustSetValidCharactersForFieldType = (DDMFormValidationException.MustSetValidCharactersForFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldType(mustSetValidCharactersForFieldType.getFieldType());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidDefaultLocaleForProperty) {
            DDMFormValidationException.MustSetValidDefaultLocaleForProperty mustSetValidDefaultLocaleForProperty = (DDMFormValidationException.MustSetValidDefaultLocaleForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidDefaultLocaleForProperty(mustSetValidDefaultLocaleForProperty.getFieldName(), mustSetValidDefaultLocaleForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidFormRuleExpression) {
            DDMFormValidationException.MustSetValidFormRuleExpression mustSetValidFormRuleExpression = (DDMFormValidationException.MustSetValidFormRuleExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidRuleExpression(mustSetValidFormRuleExpression.getExpression(), mustSetValidFormRuleExpression.getMessage());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidIndexType) {
            DDMFormValidationException.MustSetValidIndexType mustSetValidIndexType = (DDMFormValidationException.MustSetValidIndexType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidIndexType(mustSetValidIndexType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidValidationExpression) {
            DDMFormValidationException.MustSetValidValidationExpression mustSetValidValidationExpression = (DDMFormValidationException.MustSetValidValidationExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidValidationExpression(mustSetValidValidationExpression.getFieldName(), mustSetValidValidationExpression.getExpression());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidVisibilityExpression) {
            DDMFormValidationException.MustSetValidVisibilityExpression mustSetValidVisibilityExpression = (DDMFormValidationException.MustSetValidVisibilityExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidVisibilityExpression(mustSetValidVisibilityExpression.getFieldName(), mustSetValidVisibilityExpression.getExpression());
        }
        return new DataDefinitionValidationException(ddmFormValidationException.getCause());
    }

    private OrderByComparator<DDMStructure> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureNameComparator(ascending);
        }
        return new StructureModifiedDateComparator(ascending);
    }

    private String _translate(String key, ResourceBundle resourceBundle) {
        if (Validator.isNull((String)key)) {
            return "";
        }
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key), (String)key);
    }

    private DataDefinition _updateDataDefinition(DataDefinition dataDefinition, Long dataDefinitionId, DDMForm ddmForm) throws Exception {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return DataDefinitionUtil.toDataDefinition(this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), 0L, LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), new ServiceContext()), this._spiDDMFormRuleConverter);
    }

    private void _validate(DataDefinition dataDefinition, DDMForm ddmForm) {
        try {
            this._ddmFormValidator.validate(ddmForm);
            Map name = dataDefinition.getName();
            Locale defaultLocale = ddmForm.getDefaultLocale();
            if (name == null || !name.containsKey(LocaleUtil.toLanguageId((Locale)defaultLocale))) {
                throw new DataDefinitionValidationException.MustSetValidName("Name is null for locale " + defaultLocale.getDisplayName());
            }
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldsForForm) {
                return;
            }
            throw this._toDataDefinitionValidationException(ddmFormValidationException);
        }
        catch (DataDefinitionValidationException dataDefinitionValidationException) {
            throw dataDefinitionValidationException;
        }
        catch (Exception exception) {
            throw new DataDefinitionValidationException((Throwable)exception);
        }
    }
}

