/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v2.0")
public abstract class BaseDataRecordCollectionResourceImpl
implements DataRecordCollectionResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<DataRecordCollection> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-record-collection")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public DataRecordCollection getDataDefinitionDataRecordCollection(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
        return new DataRecordCollection();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-record-collections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public Page<DataRecordCollection> getDataDefinitionDataRecordCollectionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-record-collections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public DataRecordCollection postDataDefinitionDataRecordCollection(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, DataRecordCollection dataRecordCollection) throws Exception {
        return new DataRecordCollection();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-definitions/{dataDefinitionId}/data-record-collections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public Response postDataDefinitionDataRecordCollectionBatch(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(DataRecordCollection.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public void deleteDataRecordCollection(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-record-collections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public Response deleteDataRecordCollectionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(DataRecordCollection.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public DataRecordCollection getDataRecordCollection(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId) throws Exception {
        return new DataRecordCollection();
    }

    @Consumes(value={"application/json", "application/xml"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public DataRecordCollection putDataRecordCollection(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId, DataRecordCollection dataRecordCollection) throws Exception {
        return new DataRecordCollection();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/data-record-collections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public Response putDataRecordCollectionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(DataRecordCollection.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public Page<Permission> getDataRecordCollectionPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)dataRecordCollectionId, (Long)this.getPermissionCheckerGroupId(dataRecordCollectionId));
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataRecordCollectionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public void putDataRecordCollectionPermission(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(dataRecordCollectionId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)dataRecordCollectionId, (Long)this.getPermissionCheckerGroupId(dataRecordCollectionId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(dataRecordCollectionId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)dataRecordCollectionId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataRecordCollectionId")})
    @Path(value="/data-record-collections/{dataRecordCollectionId}/permissions/by-current-user")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public String getDataRecordCollectionPermissionByCurrentUser(@NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionId") Long dataRecordCollectionId) throws Exception {
        return "";
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="dataRecordCollectionKey")})
    @Path(value="/sites/{siteId}/data-record-collections/by-data-record-collection-key/{dataRecordCollectionKey}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="DataRecordCollection")})
    public DataRecordCollection getSiteDataRecordCollectionByDataRecordCollectionKey(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="dataRecordCollectionKey") String dataRecordCollectionKey) throws Exception {
        return new DataRecordCollection();
    }

    public void create(Collection<DataRecordCollection> dataRecordCollections, Map<String, Serializable> parameters) throws Exception {
        for (DataRecordCollection dataRecordCollection : dataRecordCollections) {
            this.postDataDefinitionDataRecordCollection(Long.valueOf((String)((Object)parameters.get("dataDefinitionId"))), dataRecordCollection);
        }
    }

    public void delete(Collection<DataRecordCollection> dataRecordCollections, Map<String, Serializable> parameters) throws Exception {
        for (DataRecordCollection dataRecordCollection : dataRecordCollections) {
            this.deleteDataRecordCollection(dataRecordCollection.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<DataRecordCollection> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getDataDefinitionDataRecordCollectionsPage((Long)parameters.get("dataDefinitionId"), (String)((Object)parameters.get("keywords")), pagination);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<DataRecordCollection> dataRecordCollections, Map<String, Serializable> parameters) throws Exception {
        for (DataRecordCollection dataRecordCollection : dataRecordCollections) {
            this.putDataRecordCollection(dataRecordCollection.getId() != null ? dataRecordCollection.getId() : (Long)parameters.get("dataRecordCollectionId"), dataRecordCollection);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

