/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.renderer.v2_0;

import com.liferay.data.engine.renderer.DataLayoutRenderer;
import com.liferay.data.engine.renderer.DataLayoutRendererContext;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordValuesUtil;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DataLayoutRenderer.class})
public class DataLayoutRendererImpl
implements DataLayoutRenderer {
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _ddmFormDeserializer;
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private Portal _portal;

    public String render(Long dataLayoutId, DataLayoutRendererContext dataLayoutRendererContext) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        DDMStructure ddmStructure = ddmStructureVersion.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        return this._ddmFormRenderer.render(ddmForm, ddmStructureLayout.getDDMFormLayout(), this._toDDMFormRenderingContext(dataLayoutRendererContext, ddmForm));
    }

    private DDMFormRenderingContext _toDDMFormRenderingContext(DataLayoutRendererContext dataLayoutRendererContext, DDMForm ddmForm) {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId(dataLayoutRendererContext.getContainerId());
        ddmFormRenderingContext.setDDMFormValues(DataRecordValuesUtil.toDDMFormValues(dataLayoutRendererContext.getDataRecordValues(), ddmForm, this._portal.getLocale(dataLayoutRendererContext.getHttpServletRequest())));
        ddmFormRenderingContext.setHttpServletRequest(dataLayoutRendererContext.getHttpServletRequest());
        ddmFormRenderingContext.setHttpServletResponse(dataLayoutRendererContext.getHttpServletResponse());
        ddmFormRenderingContext.setLocale(this._portal.getLocale(dataLayoutRendererContext.getHttpServletRequest()));
        ddmFormRenderingContext.setPortletNamespace(dataLayoutRendererContext.getPortletNamespace());
        ddmFormRenderingContext.setShowSubmitButton(false);
        ddmFormRenderingContext.setViewMode(true);
        return ddmFormRenderingContext;
    }
}

