/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldTypeSettings;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataDefinitionUtil {
    private static final String[] _PREDEFINED_PROPERTIES = new String[]{"indexType", "label", "localizable", "name", "predefinedValue", "readOnly", "repeatable", "required", "showLabel", "tip", "type"};
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionUtil.class);

    public static DataDefinition toDataDefinition(final DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, final DDMStructure ddmStructure, final SPIDDMFormRuleConverter spiDDMFormRuleConverter) throws Exception {
        final DDMForm ddmForm = ddmStructure.getDDMForm();
        return new DataDefinition(){
            {
                this.availableLanguageIds = DataDefinitionUtil._toLanguageIds(ddmForm.getAvailableLocales());
                this.dataDefinitionFields = DataDefinitionUtil._toDataDefinitionFields(ddmForm.getDDMFormFields(), ddmFormFieldTypeServicesTracker);
                this.dataDefinitionKey = ddmStructure.getStructureKey();
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.defaultDataLayout = DataLayoutUtil.toDataLayout(ddmStructure.fetchDDMStructureLayout(), spiDDMFormRuleConverter);
                this.defaultLanguageId = LanguageUtil.getLanguageId((Locale)ddmForm.getDefaultLocale());
                this.description = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap());
                this.id = ddmStructure.getStructureId();
                this.name = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap());
                this.siteId = ddmStructure.getGroupId();
                this.storageType = ddmStructure.getStorageType();
                this.userId = ddmStructure.getUserId();
            }
        };
    }

    public static DDMForm toDDMForm(DataDefinition dataDefinition, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        if (dataDefinition == null) {
            return new DDMForm();
        }
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(DataDefinitionUtil._toLocales(dataDefinition.getAvailableLanguageIds()));
        ddmForm.setDDMFormFields(DataDefinitionUtil._toDDMFormFields(dataDefinition.getDataDefinitionFields(), ddmFormFieldTypeServicesTracker));
        ddmForm.setDefaultLocale(LocaleUtil.fromLanguageId((String)dataDefinition.getDefaultLanguageId()));
        return ddmForm;
    }

    private static Map<String, Object> _getCustomProperties(DDMFormField ddmFormField, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        Map<String, DDMFormField> settingsDDMFormFieldsMap = DataDefinitionUtil._getSettingsDDMFormFields(ddmFormFieldTypeServicesTracker, ddmFormField.getType());
        Map properties = ddmFormField.getProperties();
        HashMap<String, Object> customProperties = new HashMap<String, Object>();
        for (Map.Entry entry : properties.entrySet()) {
            DDMFormField settingsDDMFormField;
            if (ArrayUtil.contains((Object[])_PREDEFINED_PROPERTIES, entry.getKey()) || (settingsDDMFormField = settingsDDMFormFieldsMap.get(entry.getKey())) == null) continue;
            if (settingsDDMFormField.isLocalizable()) {
                customProperties.put((String)entry.getKey(), LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)((LocalizedValue)entry.getValue())));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "boolean")) {
                customProperties.put((String)entry.getKey(), GetterUtil.getBoolean(entry.getValue()));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "ddm-options")) {
                customProperties.put((String)entry.getKey(), DataDefinitionUtil._toMap((DDMFormFieldOptions)entry.getValue()));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getType(), "validation")) {
                customProperties.put((String)entry.getKey(), DataDefinitionUtil._toMap((DDMFormFieldValidation)entry.getValue()));
                continue;
            }
            customProperties.put((String)entry.getKey(), entry.getValue());
        }
        return customProperties;
    }

    private static DDMFormFieldOptions _getDDMFormFieldOptions(Map<String, ?> options) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        if (MapUtil.isEmpty(options)) {
            return ddmFormFieldOptions;
        }
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            Object value = entry.getValue();
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                Object[] values;
                for (Object curValue : values = (Object[])value) {
                    try {
                        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)curValue.toString());
                        ddmFormFieldOptions.addOptionLabel(jsonObject.getString("value"), LocaleUtil.fromLanguageId((String)entry.getKey()), jsonObject.getString("label"));
                    }
                    catch (JSONException jsonException) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Object)jsonException, (Throwable)jsonException);
                    }
                }
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object option : (List)value) {
                if (option instanceof Map) {
                    ddmFormFieldOptions.addOptionLabel(MapUtil.getString((Map)((Map)option), (String)"value"), LocaleUtil.fromLanguageId((String)entry.getKey()), MapUtil.getString((Map)((Map)option), (String)"label"));
                    continue;
                }
                if (!(option instanceof String)) continue;
                try {
                    JSONObject optionJSONObject = JSONFactoryUtil.createJSONObject((String)option.toString());
                    ddmFormFieldOptions.addOptionLabel(JSONUtil.getValueAsString((Object)optionJSONObject, (String[])new String[]{"Object/value"}), LocaleUtil.fromLanguageId((String)entry.getKey()), JSONUtil.getValueAsString((Object)optionJSONObject, (String[])new String[]{"Object/label"}));
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)jsonException, (Throwable)jsonException);
                }
            }
        }
        return ddmFormFieldOptions;
    }

    private static DDMFormFieldValidation _getDDMFormFieldValidation(Map<String, Object> value) {
        if (MapUtil.isEmpty(value)) {
            return null;
        }
        final Map expression = (Map)value.get("expression");
        if (Validator.isNull((String)MapUtil.getString((Map)expression, (String)"value"))) {
            return null;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
            {
                this.setName(MapUtil.getString((Map)expression, (String)"name"));
                this.setValue(MapUtil.getString((Map)expression, (String)"value"));
            }
        });
        ddmFormFieldValidation.setErrorMessageLocalizedValue(LocalizedValueUtil.toLocalizedValue((Map)((Map)value.get("errorMessage"))));
        ddmFormFieldValidation.setParameterLocalizedValue(LocalizedValueUtil.toLocalizedValue((Map)((Map)value.get("parameter"))));
        return ddmFormFieldValidation;
    }

    private static Map<String, DDMFormField> _getSettingsDDMFormFields(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, String type) {
        DDMFormFieldType ddmFormFieldType = ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
        Class ddmFormFieldTypeSettings = DefaultDDMFormFieldTypeSettings.class;
        if (ddmFormFieldType != null) {
            ddmFormFieldTypeSettings = ddmFormFieldType.getDDMFormFieldTypeSettings();
        }
        DDMForm settingsDDMForm = DDMFormFactory.create(ddmFormFieldTypeSettings);
        return settingsDDMForm.getDDMFormFieldsMap(true);
    }

    private static DataDefinitionField _toDataDefinitionField(final DDMFormField ddmFormField, final DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        return new DataDefinitionField(){
            {
                this.customProperties = DataDefinitionUtil._getCustomProperties(ddmFormField, ddmFormFieldTypeServicesTracker);
                this.defaultValue = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getPredefinedValue());
                this.fieldType = ddmFormField.getType();
                this.indexable = Validator.isNotNull((String)ddmFormField.getIndexType());
                this.indexType = DataDefinitionField.IndexType.create((String)ddmFormField.getIndexType());
                this.label = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getLabel());
                this.localizable = ddmFormField.isLocalizable();
                this.name = ddmFormField.getName();
                this.nestedDataDefinitionFields = DataDefinitionUtil._toDataDefinitionFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldTypeServicesTracker);
                this.readOnly = ddmFormField.isReadOnly();
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.tip = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getTip());
            }
        };
    }

    private static DataDefinitionField[] _toDataDefinitionFields(List<DDMFormField> ddmFormFields, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        if (ListUtil.isEmpty(ddmFormFields)) {
            return new DataDefinitionField[0];
        }
        Stream stream = ddmFormFields.stream();
        return stream.map(ddmFormField -> DataDefinitionUtil._toDataDefinitionField(ddmFormField, ddmFormFieldTypeServicesTracker)).collect(Collectors.toList()).toArray(new DataDefinitionField[0]);
    }

    private static DDMFormField _toDDMFormField(DataDefinitionField dataDefinitionField, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        DDMFormField ddmFormField = new DDMFormField();
        ddmFormField.setIndexType(dataDefinitionField.getIndexTypeAsString());
        ddmFormField.setLabel(LocalizedValueUtil.toLocalizedValue((Map)dataDefinitionField.getLabel()));
        ddmFormField.setLocalizable(GetterUtil.getBoolean((Object)dataDefinitionField.getLocalizable()));
        ddmFormField.setName(dataDefinitionField.getName());
        ddmFormField.setNestedDDMFormFields(DataDefinitionUtil._toDDMFormFields(dataDefinitionField.getNestedDataDefinitionFields(), ddmFormFieldTypeServicesTracker));
        Map defaultValue = dataDefinitionField.getDefaultValue();
        if (defaultValue != null) {
            defaultValue.forEach((key, value) -> {
                if (value instanceof ArrayList) {
                    JSONArray jsonArray = JSONFactoryUtil.createJSONArray((Collection)((ArrayList)value));
                    value = jsonArray.toString();
                }
                defaultValue.put(key, value);
            });
        }
        ddmFormField.setPredefinedValue(LocalizedValueUtil.toLocalizedValue((Map)defaultValue));
        ddmFormField.setReadOnly(GetterUtil.getBoolean((Object)dataDefinitionField.getReadOnly()));
        ddmFormField.setRepeatable(GetterUtil.getBoolean((Object)dataDefinitionField.getRepeatable()));
        ddmFormField.setRequired(GetterUtil.getBoolean((Object)dataDefinitionField.getRequired()));
        ddmFormField.setShowLabel(GetterUtil.getBoolean((Object)dataDefinitionField.getShowLabel()));
        ddmFormField.setTip(LocalizedValueUtil.toLocalizedValue((Map)dataDefinitionField.getTip()));
        ddmFormField.setType(dataDefinitionField.getFieldType());
        Map customProperties = dataDefinitionField.getCustomProperties();
        if (MapUtil.isNotEmpty((Map)customProperties)) {
            Map<String, DDMFormField> settingsDDMFormFieldsMap = DataDefinitionUtil._getSettingsDDMFormFields(ddmFormFieldTypeServicesTracker, dataDefinitionField.getFieldType());
            for (Map.Entry entry : customProperties.entrySet()) {
                DDMFormField settingsDDMFormField;
                if (ArrayUtil.contains((Object[])_PREDEFINED_PROPERTIES, entry.getKey()) || (settingsDDMFormField = settingsDDMFormFieldsMap.get(entry.getKey())) == null) continue;
                if (settingsDDMFormField.isLocalizable()) {
                    ddmFormField.setProperty((String)entry.getKey(), (Object)LocalizedValueUtil.toLocalizedValue((Map)((Map)entry.getValue())));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getDataType(), "boolean")) {
                    ddmFormField.setProperty((String)entry.getKey(), (Object)GetterUtil.getBoolean(entry.getValue()));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getDataType(), "ddm-options")) {
                    ddmFormField.setProperty((String)entry.getKey(), (Object)DataDefinitionUtil._getDDMFormFieldOptions((Map)entry.getValue()));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getType(), "validation")) {
                    ddmFormField.setProperty((String)entry.getKey(), (Object)DataDefinitionUtil._getDDMFormFieldValidation((Map)entry.getValue()));
                    continue;
                }
                ddmFormField.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return ddmFormField;
    }

    private static List<DDMFormField> _toDDMFormFields(DataDefinitionField[] dataDefinitionFields, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        if (ArrayUtil.isEmpty((Object[])dataDefinitionFields)) {
            return Collections.emptyList();
        }
        return Stream.of(dataDefinitionFields).map(dataDefinitionField -> DataDefinitionUtil._toDDMFormField(dataDefinitionField, ddmFormFieldTypeServicesTracker)).collect(Collectors.toList());
    }

    private static String[] _toLanguageIds(Set<Locale> locales) {
        Stream stream = locales.stream();
        return stream.map(LanguageUtil::getLanguageId).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static Set<Locale> _toLocales(String[] languageIds) {
        if (ArrayUtil.isEmpty((Object[])languageIds)) {
            return Collections.emptySet();
        }
        return Stream.of(languageIds).map(LocaleUtil::fromLanguageId).collect(Collectors.toSet());
    }

    private static Map<String, List<Map<String, String>>> _toMap(DDMFormFieldOptions ddmFormFieldOptions) {
        Set optionsValues = ddmFormFieldOptions.getOptionsValues();
        if (optionsValues.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, String>>> options = new HashMap<String, List<Map<String, String>>>();
        for (String optionValue : optionsValues) {
            LocalizedValue localizedValue = ddmFormFieldOptions.getOptionLabels(optionValue);
            for (Locale locale : localizedValue.getAvailableLocales()) {
                String languageId = LanguageUtil.getLanguageId((Locale)locale);
                if (options.containsKey(languageId)) {
                    List values = (List)options.get(languageId);
                    values.add(HashMapBuilder.put((Object)"label", (Object)localizedValue.getString(locale)).put((Object)"value", (Object)optionValue).build());
                    continue;
                }
                options.put(languageId, ListUtil.toList((Object)HashMapBuilder.put((Object)"label", (Object)localizedValue.getString(locale)).put((Object)"value", (Object)optionValue).build()));
            }
        }
        return options;
    }

    private static Map<String, Object> _toMap(DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return Collections.emptyMap();
        }
        return HashMapBuilder.put((Object)"errorMessage", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getErrorMessageLocalizedValue())).put((Object)"expression", DataDefinitionUtil._toMap(ddmFormFieldValidation.getDDMFormFieldValidationExpression())).put((Object)"parameter", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getParameterLocalizedValue())).build();
    }

    private static Map<String, Object> _toMap(DDMFormFieldValidationExpression ddmFormFieldValidationExpression) {
        if (ddmFormFieldValidationExpression == null) {
            return Collections.emptyMap();
        }
        return HashMapBuilder.put((Object)"name", (Object)ddmFormFieldValidationExpression.getName()).put((Object)"value", (Object)ddmFormFieldValidationExpression.getValue()).build();
    }
}

