/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.rule.function.v1_0;

import com.liferay.data.engine.rule.function.DataRuleFunction;
import com.liferay.data.engine.rule.function.DataRuleFunctionResult;
import com.liferay.data.engine.spi.dto.SPIDataDefinitionField;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"data.engine.rule.function.name=decimalLiteral", "data.engine.rule.function.type=validation"}, service={DataRuleFunction.class})
public class DecimalLiteralDataRuleFunction
implements DataRuleFunction {
    private static final Log _log = LogFactoryUtil.getLog(DecimalLiteralDataRuleFunction.class);

    public DataRuleFunctionResult validate(Map<String, Object> dataDefinitionRuleParameters, SPIDataDefinitionField spiDataDefinitionField, Object value) {
        DataRuleFunctionResult dataRuleFunctionResult;
        block3: {
            dataRuleFunctionResult = DataRuleFunctionResult.of((SPIDataDefinitionField)spiDataDefinitionField, (String)"value-must-be-a-decimal-value");
            if (value == null) {
                return dataRuleFunctionResult;
            }
            try {
                new BigDecimal(value.toString());
                dataRuleFunctionResult.setValid(true);
            }
            catch (NumberFormatException numberFormatException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)numberFormatException, (Throwable)numberFormatException);
            }
        }
        return dataRuleFunctionResult;
    }
}

