/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0.util;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;

public class DataEnginePermissionUtil {
    private static final Log _log = LogFactoryUtil.getLog(DataEnginePermissionUtil.class);

    public static void checkOperationPermission(GroupLocalService groupLocalService, String operation, long siteId) throws Exception {
        if (!StringUtil.equalsIgnoreCase((String)"delete", (String)operation) && !StringUtil.equalsIgnoreCase((String)"save", (String)operation)) {
            throw new ValidationException("Operation must be 'delete' or 'save'");
        }
        DataEnginePermissionUtil.checkPermission("DEFINE_PERMISSIONS", groupLocalService, siteId);
    }

    public static void checkPermission(String actionId, GroupLocalService groupLocalService, Long siteId) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Group group = groupLocalService.fetchGroup(siteId.longValue());
        if (group != null && group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (!permissionChecker.hasPermission(group, "com.liferay.data.engine", siteId.longValue(), actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, "com.liferay.data.engine", siteId.longValue(), new String[]{actionId});
        }
    }

    public static List<Role> getRoles(Company company, RoleLocalService roleLocalService, String[] roleNames) throws PortalException {
        ArrayList<String> invalidRoleNames = new ArrayList<String>();
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String roleName : roleNames) {
            try {
                Role role = roleLocalService.getRole(company.getCompanyId(), roleName);
                roles.add(role);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)roleName, (Throwable)noSuchRoleException);
                }
                invalidRoleNames.add(roleName);
            }
        }
        if (!invalidRoleNames.isEmpty()) {
            throw new ValidationException("Invalid roles: " + ArrayUtil.toStringArray(invalidRoleNames));
        }
        return roles;
    }

    public static void persistModelPermission(List<String> actionIds, Company company, long modelId, String operation, String resourceName, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, String[] roleNames, long siteId) throws Exception {
        if (StringUtil.equalsIgnoreCase((String)"save", (String)operation)) {
            ModelPermissions modelPermissions = new ModelPermissions();
            for (String roleName : roleNames) {
                modelPermissions.addRolePermissions(roleName, ArrayUtil.toStringArray(actionIds));
            }
            resourcePermissionLocalService.addModelResourcePermissions(company.getCompanyId(), siteId, PrincipalThreadLocal.getUserId(), resourceName, String.valueOf(modelId), modelPermissions);
        } else {
            for (Role role : DataEnginePermissionUtil.getRoles(company, roleLocalService, roleNames)) {
                for (String actionId : actionIds) {
                    resourcePermissionLocalService.removeResourcePermission(company.getCompanyId(), resourceName, 4, String.valueOf(modelId), role.getRoleId(), actionId);
                }
            }
        }
    }

    public static void persistPermission(List<String> actionIds, Company company, String operation, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, String[] roleNames) throws Exception {
        List<Role> roles = DataEnginePermissionUtil.getRoles(company, roleLocalService, roleNames);
        if (StringUtil.equalsIgnoreCase((String)"save", (String)operation)) {
            for (Role role : roles) {
                resourcePermissionLocalService.setResourcePermissions(company.getCompanyId(), "com.liferay.data.engine", 1, String.valueOf(company.getCompanyId()), role.getRoleId(), ArrayUtil.toStringArray(actionIds));
            }
        } else {
            for (Role role : roles) {
                ResourcePermission resourcePermission = resourcePermissionLocalService.fetchResourcePermission(company.getCompanyId(), "com.liferay.data.engine", 1, String.valueOf(company.getCompanyId()), role.getRoleId());
                if (resourcePermission == null) continue;
                resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
            }
        }
    }
}

