/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPermission;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataLayout;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.odata.entity.v1_0.DataLayoutEntityModel;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataLayoutResourceImpl;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.data.engine.rest.resource.v1_0.DataLayoutResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutNameComparator;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-layout.properties"}, scope=ServiceScope.PROTOTYPE, service={DataLayoutResource.class})
public class DataLayoutResourceImpl
extends BaseDataLayoutResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new DataLayoutEntityModel();
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private ModelResourcePermission<InternalDataRecordCollection> _modelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public void deleteDataLayout(Long dataLayoutId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "DELETE");
        this._ddmStructureLayoutLocalService.deleteDDMStructureLayout(dataLayoutId.longValue());
    }

    @Override
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(Long dataDefinitionId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLayoutLocalService.getStructureLayouts(ddmStructure.getGroupId(), this._portal.getClassNameId(InternalDataLayout.class), this._getDDMStructureVersionId(dataDefinitionId), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataLayout), (Pagination)pagination, (long)this._ddmStructureLayoutLocalService.getStructureLayoutsCount(ddmStructure.getGroupId(), this._portal.getClassNameId(InternalDataLayout.class), this._getDDMStructureVersionId(dataDefinitionId)));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDMStructureLayout.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(InternalDataLayout.class)));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("structureVersionId", (Serializable)Long.valueOf(this._getDDMStructureVersionId(dataDefinitionId)));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
        }, document -> this._toDataLayout(this._ddmStructureLayoutLocalService.getStructureLayout(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public DataLayout getDataLayout(Long dataLayoutId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "VIEW");
        return this._toDataLayout(this._ddmStructureLayoutLocalService.getDDMStructureLayout(dataLayoutId.longValue()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataLayout getSiteDataLayout(Long siteId, String dataLayoutKey) throws Exception {
        return this._toDataLayout(this._ddmStructureLayoutLocalService.getStructureLayout(siteId.longValue(), this._getClassNameId(), dataLayoutKey));
    }

    @Override
    public Page<DataLayout> getSiteDataLayoutsPage(Long siteId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLayoutLocalService.getStructureLayouts(siteId.longValue(), this._portal.getClassNameId(InternalDataLayout.class), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataLayout), (Pagination)pagination, (long)this._ddmStructureLayoutLocalService.getStructureLayoutsCount(siteId.longValue(), this._portal.getClassNameId(InternalDataLayout.class)));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDMStructureLayout.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(InternalDataLayout.class)));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._toDataLayout(this._ddmStructureLayoutLocalService.getStructureLayout(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public DataLayout postDataDefinitionDataLayout(Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        if (MapUtil.isEmpty((Map)dataLayout.getName())) {
            throw new Exception("Name is required");
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkPermission("ADD_DATA_LAYOUT", this._groupLocalService, ddmStructure.getGroupId());
        String dataLayoutJSON = DataLayoutUtil.toJSON(dataLayout);
        ServiceContext serviceContext = new ServiceContext();
        dataLayout = this._toDataLayout(this._ddmStructureLayoutLocalService.addStructureLayout(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), this._getClassNameId(), dataLayout.getDataLayoutKey(), this._getDDMStructureVersionId(dataDefinitionId), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getDescription()), dataLayoutJSON, serviceContext));
        this._resourceLocalService.addModelResources(this.contextCompany.getCompanyId(), ddmStructure.getGroupId(), PrincipalThreadLocal.getUserId(), InternalDataLayout.class.getName(), dataLayout.getId().longValue(), serviceContext.getModelPermissions());
        DocumentContext documentContext = JsonPath.parse((String)dataLayoutJSON);
        List fieldNames = (List)documentContext.read("$[\"pages\"][*][\"rows\"][*][\"columns\"][*][\"fieldNames\"][*]", new Predicate[0]);
        for (String fieldName : fieldNames) {
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(dataLayout.getSiteId().longValue(), this._getClassNameId(), dataLayout.getId().longValue(), dataDefinitionId.longValue(), fieldName);
        }
        return dataLayout;
    }

    @Override
    public void postDataLayoutDataLayoutPermission(Long dataLayoutId, String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddmStructureLayout.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataLayoutPermission.getDelete())) {
            actionIds.add("DELETE");
        }
        if (GetterUtil.getBoolean((Object)dataLayoutPermission.getUpdate())) {
            actionIds.add("UPDATE");
        }
        if (GetterUtil.getBoolean((Object)dataLayoutPermission.getView())) {
            actionIds.add("VIEW");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, this.contextCompany, dataLayoutId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataLayout", this._resourcePermissionLocalService, this._roleLocalService, dataLayoutPermission.getRoleNames(), ddmStructureLayout.getGroupId());
    }

    @Override
    public void postSiteDataLayoutPermission(Long siteId, String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataLayoutPermission.getAddDataLayout())) {
            actionIds.add("ADD_DATA_LAYOUT");
        }
        if (GetterUtil.getBoolean((Object)dataLayoutPermission.getDefinePermissions())) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, this.contextCompany, operation, this._resourcePermissionLocalService, this._roleLocalService, dataLayoutPermission.getRoleNames());
    }

    @Override
    public DataLayout putDataLayout(Long dataLayoutId, DataLayout dataLayout) throws Exception {
        if (MapUtil.isEmpty((Map)dataLayout.getName())) {
            throw new Exception("Name is required");
        }
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "UPDATE");
        return this._toDataLayout(this._ddmStructureLayoutLocalService.updateStructureLayout(dataLayoutId.longValue(), this._getDDMStructureVersionId(dataLayout.getDataDefinitionId()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getDescription()), DataLayoutUtil.toJSON(dataLayout), new ServiceContext()));
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataLayout)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataRecordCollection> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(InternalDataLayout.class);
    }

    private long _getDDMStructureId(DDMStructureLayout ddmStructureLayout) throws Exception {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        DDMStructure ddmStructure = ddmStructureVersion.getStructure();
        return ddmStructure.getStructureId();
    }

    private long _getDDMStructureVersionId(Long deDataDefinitionId) throws Exception {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(deDataDefinitionId.longValue());
        return ddmStructureVersion.getStructureVersionId();
    }

    private DataLayout _toDataLayout(DDMStructureLayout ddmStructureLayout) throws Exception {
        DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDefinition());
        dataLayout.setDateCreated(ddmStructureLayout.getCreateDate());
        dataLayout.setDataDefinitionId(Long.valueOf(this._getDDMStructureId(ddmStructureLayout)));
        dataLayout.setDataLayoutKey(ddmStructureLayout.getStructureLayoutKey());
        dataLayout.setDateModified(ddmStructureLayout.getModifiedDate());
        dataLayout.setDescription(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getDescriptionMap()));
        dataLayout.setId(Long.valueOf(ddmStructureLayout.getStructureLayoutId()));
        dataLayout.setName(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getNameMap()));
        dataLayout.setSiteId(Long.valueOf(ddmStructureLayout.getGroupId()));
        dataLayout.setUserId(Long.valueOf(ddmStructureLayout.getUserId()));
        return dataLayout;
    }

    private OrderByComparator<DDMStructureLayout> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureLayoutCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureLayoutNameComparator(ascending);
        }
        return new StructureLayoutModifiedDateComparator(ascending);
    }
}

