/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.field.type.FieldTypeTracker;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionPermission;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataDefinition;
import com.liferay.data.engine.rest.internal.model.InternalDataLayout;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.odata.entity.v1_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.common.CommonDataRecordCollectionResource;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.data.engine.rest.resource.v1_0.DataDefinitionResource;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.StructureCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection)")
    private ModelResourcePermission<InternalDataRecordCollection> _dataRecordCollectionModelResourcePermission;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private FieldTypeTracker _fieldTypeTracker;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    private ModelResourcePermission<InternalDataDefinition> _modelResourcePermission;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "DELETE");
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(dataDefinitionId.longValue());
        List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(dataDefinitionId.longValue());
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this._ddmStructureLayoutLocalService.deleteDDMStructureLayouts(this._portal.getClassNameId(InternalDataLayout.class), ddmStructureVersion);
            this._ddmStructureVersionLocalService.deleteDDMStructureVersion(ddmStructureVersion);
        }
        this._ddmStructureLocalService.deleteDDMStructure(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()), this._fieldTypeTracker);
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Collection fieldTypes = this._fieldTypeTracker.getFieldTypes();
        Stream stream = fieldTypes.stream();
        stream.map(fieldType -> DataDefinitionUtil.getFieldTypeMetadataJSONObject(this.contextAcceptLanguage, this._ddmFormFieldTypeServicesTracker, this._ddmFormTemplateContextFactory, this._ddmFormValuesFactory, fieldType, this._fieldTypeTracker, this.contextHttpServletRequest, this._npmResolver, this._getResourceBundle(this.contextAcceptLanguage.getPreferredLocale()))).filter(jsonObject -> !jsonObject.getBoolean("system")).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toJSONString();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataDefinition getSiteDataDefinition(Long siteId, String dataDefinitionKey) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(siteId.longValue(), this._getClassNameId(), dataDefinitionKey), this._fieldTypeTracker);
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionsPage(Long siteId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLocalService.getStructures(siteId.longValue(), this._portal.getClassNameId(InternalDataDefinition.class), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataDefinition), (Pagination)pagination, (long)this._ddmStructureLocalService.getStructuresCount(siteId.longValue(), this._portal.getClassNameId(InternalDataDefinition.class)));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDMStructure.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(InternalDataDefinition.class)));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)document.get("entryClassPK"))), this._fieldTypeTracker), (Sort[])sorts);
    }

    @Override
    public void postDataDefinitionDataDefinitionPermission(Long dataDefinitionId, String operation, DataDefinitionPermission dataDefinitionPermission) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddmStructure.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getDelete())) {
            actionIds.add("DELETE");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getUpdate())) {
            actionIds.add("UPDATE");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getView())) {
            actionIds.add("VIEW");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, this.contextCompany, dataDefinitionId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataDefinition", this._resourcePermissionLocalService, this._roleLocalService, dataDefinitionPermission.getRoleNames(), ddmStructure.getGroupId());
    }

    @Override
    public DataDefinition postSiteDataDefinition(Long siteId, DataDefinition dataDefinition) throws Exception {
        DataEnginePermissionUtil.checkPermission("ADD_DATA_DEFINITION", this._groupLocalService, siteId);
        ServiceContext serviceContext = new ServiceContext();
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, this._getClassNameId(), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), DataDefinitionUtil.toJSON(dataDefinition, this._fieldTypeTracker), GetterUtil.getString((String)dataDefinition.getStorageType(), (String)"json"), serviceContext), this._fieldTypeTracker);
        this._resourceLocalService.addModelResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), InternalDataDefinition.class.getName(), dataDefinition.getId().longValue(), serviceContext.getModelPermissions());
        CommonDataRecordCollectionResource commonDataRecordCollectionResource = new CommonDataRecordCollectionResource(this._ddlRecordSetLocalService, this._ddmStructureLocalService, this._groupLocalService, this._dataRecordCollectionModelResourcePermission, this._resourceLocalService, this._resourcePermissionLocalService, this._roleLocalService, DataRecordCollectionUtil::toDataRecordCollection);
        commonDataRecordCollectionResource.postDataDefinitionDataRecordCollection(this.contextCompany, dataDefinition.getId(), dataDefinition.getDataDefinitionKey(), dataDefinition.getDescription(), dataDefinition.getName());
        return dataDefinition;
    }

    @Override
    public void postSiteDataDefinitionPermission(Long siteId, String operation, DataDefinitionPermission dataDefinitionPermission) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getAddDataDefinition())) {
            actionIds.add("ADD_DATA_DEFINITION");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getDefinePermissions())) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, this.contextCompany, operation, this._resourcePermissionLocalService, this._roleLocalService, dataDefinitionPermission.getRoleNames());
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "UPDATE");
        return DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), 0L, LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), DataDefinitionUtil.toJSON(dataDefinition, this._fieldTypeTracker), new ServiceContext()), this._fieldTypeTracker);
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataDefinition)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataDefinition> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(InternalDataDefinition.class);
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), this._portal.getResourceBundle(locale)});
    }

    private DataDefinition _toDataDefinition(DDMStructure ddmStructure) throws Exception {
        return DataDefinitionUtil.toDataDefinition(ddmStructure, this._fieldTypeTracker);
    }

    private OrderByComparator<DDMStructure> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureNameComparator(ascending);
        }
        return new StructureModifiedDateComparator(ascending);
    }
}

