/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.common;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.validation.ValidationException;

public class CommonDataRecordCollectionResource<T> {
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final GroupLocalService _groupLocalService;
    private final ModelResourcePermission<InternalDataRecordCollection> _modelResourcePermission;
    private final ResourceLocalService _resourceLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final UnsafeFunction<DDLRecordSet, T, Exception> _transformUnsafeFunction;

    public CommonDataRecordCollectionResource(DDLRecordSetLocalService ddlRecordSetLocalService, DDMStructureLocalService ddmStructureLocalService, GroupLocalService groupLocalService, ModelResourcePermission<InternalDataRecordCollection> modelResourcePermission, ResourceLocalService resourceLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, UnsafeFunction<DDLRecordSet, T, Exception> transformUnsafeFunction) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._groupLocalService = groupLocalService;
        this._modelResourcePermission = modelResourcePermission;
        this._resourceLocalService = resourceLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._transformUnsafeFunction = transformUnsafeFunction;
    }

    public void deleteDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "DELETE");
        this._ddlRecordSetLocalService.deleteRecordSet(dataRecordCollectionId.longValue());
    }

    public Page<T> getDataDefinitionDataRecordCollectionsPage(AcceptLanguage acceptLanguage, Company company, Long dataDefinitionId, String keywords, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)acceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        if (Validator.isNull((String)keywords)) {
            return Page.of((Collection)TransformUtil.transform((Collection)this._ddlRecordSetLocalService.search(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), this._transformUnsafeFunction), (Pagination)pagination, (long)this._ddlRecordSetLocalService.searchCount(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDLRecordSet.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("DDMStructureId", (Serializable)Long.valueOf(ddmStructure.getStructureId()));
            searchContext.setAttribute("scope", (Serializable)Integer.valueOf(3));
            searchContext.setCompanyId(company.getCompanyId());
            searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
        }, document -> this._transformUnsafeFunction.apply((Object)this._ddlRecordSetLocalService.getRecordSet(GetterUtil.getLong((String)document.get("entryClassPK")))), null);
    }

    public T getDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "VIEW");
        return (T)this._transformUnsafeFunction.apply((Object)this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue()));
    }

    public T getSiteDataRecordCollection(String dataRecordCollectionKey, Long siteId) throws Exception {
        return (T)this._transformUnsafeFunction.apply((Object)this._ddlRecordSetLocalService.getRecordSet(siteId.longValue(), dataRecordCollectionKey));
    }

    public Page<T> getSiteDataRecordCollectionsPage(AcceptLanguage acceptLanguage, Company company, String keywords, Pagination pagination, Long siteId) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)acceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of((Collection)TransformUtil.transform((Collection)this._ddlRecordSetLocalService.search(company.getCompanyId(), siteId.longValue(), keywords, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), this._transformUnsafeFunction), (Pagination)pagination, (long)this._ddlRecordSetLocalService.searchCount(company.getCompanyId(), siteId.longValue(), keywords, 3));
        }
        return SearchUtil.search(booleanQuery -> {}, null, DDLRecordSet.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setAttribute("scope", (Serializable)Integer.valueOf(3));
            searchContext.setCompanyId(company.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, document -> this._transformUnsafeFunction.apply((Object)this._ddlRecordSetLocalService.getRecordSet(GetterUtil.getLong((String)document.get("entryClassPK")))), null);
    }

    public T postDataDefinitionDataRecordCollection(Company company, Long dataDefinitionId, String dataRecordCollectionKey, Map<String, Object> description, Map<String, Object> name) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkPermission("ADD_DATA_RECORD_COLLECTION", this._groupLocalService, ddmStructure.getGroupId());
        ServiceContext serviceContext = new ServiceContext();
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.addRecordSet(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), dataDefinitionId.longValue(), dataRecordCollectionKey, LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), 0, 3, serviceContext);
        this._resourceLocalService.addModelResources(company.getCompanyId(), ddmStructure.getGroupId(), PrincipalThreadLocal.getUserId(), InternalDataRecordCollection.class.getName(), ddlRecordSet.getPrimaryKey(), serviceContext.getModelPermissions());
        return (T)this._transformUnsafeFunction.apply((Object)ddlRecordSet);
    }

    public void postDataRecordCollectionDataRecordCollectionPermissions(Company company, Long dataRecordCollectionId, boolean hasAddDataRecordPermission, boolean hasDeletePermission, boolean hasDeleteDataRecordPermission, boolean hasUpdatePermission, boolean hasUpdateDataRecordPermission, boolean hasViewPermission, boolean hasViewDataRecordPermission, boolean hasExportDataRecordPermission, String operation, String[] roleNames) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddlRecordSet.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (hasAddDataRecordPermission) {
            actionIds.add("ADD_DATA_RECORD");
        }
        if (hasDeletePermission) {
            actionIds.add("DELETE");
        }
        if (hasDeleteDataRecordPermission) {
            actionIds.add("DELETE_DATA_RECORD");
        }
        if (hasExportDataRecordPermission) {
            actionIds.add("EXPORT_DATA_RECORDS");
        }
        if (hasUpdatePermission) {
            actionIds.add("UPDATE");
        }
        if (hasUpdateDataRecordPermission) {
            actionIds.add("UPDATE_DATA_RECORD");
        }
        if (hasViewPermission) {
            actionIds.add("VIEW");
        }
        if (hasViewDataRecordPermission) {
            actionIds.add("VIEW_DATA_RECORD");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, company, dataRecordCollectionId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection", this._resourcePermissionLocalService, this._roleLocalService, roleNames, ddlRecordSet.getGroupId());
    }

    public void postSiteDataRecordCollectionPermissions(Company company, boolean hasAddDataRecordCollectionPermission, boolean hasDefinePermissionsPermission, String operation, String[] roleNames, Long siteId) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (hasAddDataRecordCollectionPermission) {
            actionIds.add("ADD_DATA_RECORD_COLLECTION");
        }
        if (hasDefinePermissionsPermission) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, company, operation, this._resourcePermissionLocalService, this._roleLocalService, roleNames);
    }

    public T putDataRecordCollection(Long dataRecordCollectionId, Map<String, Object> description, Map<String, Object> name) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "UPDATE");
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(PrincipalThreadLocal.getUserId());
        return (T)this._transformUnsafeFunction.apply((Object)this._ddlRecordSetLocalService.updateRecordSet(dataRecordCollectionId.longValue(), ddlRecordSet.getDDMStructureId(), LocalizedValueUtil.toLocaleStringMap(name), LocalizedValueUtil.toLocaleStringMap(description), 0, serviceContext));
    }
}

