/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CustomPropertiesUtil {
    public static <K, V> Map<K, V> getMap(Map<String, Object> customProperties, String key) {
        if (MapUtil.isEmpty(customProperties)) {
            return Collections.emptyMap();
        }
        return (Map)GetterUtil.getObject((Object)customProperties.get(key), Collections.emptyMap());
    }

    public static String getString(Map<String, Object> customProperties, String key) {
        return CustomPropertiesUtil.getString(customProperties, key, "");
    }

    public static String getString(Map<String, Object> customProperties, String key, String defaultValue) {
        if (MapUtil.isEmpty(customProperties)) {
            return defaultValue;
        }
        return GetterUtil.getString((Object)customProperties.get(key), (String)defaultValue);
    }

    public static <T> T getValue(Map<String, Object> customProperties, String key) {
        return (T)GetterUtil.getObject((Object)customProperties.get(key), Collections.emptyMap());
    }

    public static List<String> getValues(Map<String, Object> customProperties, String key) {
        String json = CustomPropertiesUtil.getString(customProperties, key, "[]");
        JSONArray jsonArray = null;
        try {
            jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        }
        catch (JSONException jsonException) {
            jsonArray = JSONFactoryUtil.createJSONArray();
        }
        return JSONUtil.toStringList((JSONArray)jsonArray);
    }

    public static JSONObject toJSONObject(Map<String, String> values) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (values.isEmpty()) {
            return jsonObject;
        }
        for (Map.Entry<String, String> entry : values.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }

    public static Map<String, String> toMap(JSONObject jsonObject) {
        HashMap<String, String> values = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            values.put(key, jsonObject.getString(key));
        }
        return values;
    }
}

