/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v1_0.util;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutRow;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.Objects;

public class DataLayoutUtil {
    public static DataLayout toDataLayout(String json) throws Exception {
        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        return new DataLayout(){
            {
                this.dataLayoutPages = (DataLayoutPage[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("pages"), pageJSONObject -> DataLayoutUtil._toDataLayoutPage(pageJSONObject), DataLayoutPage.class);
                this.paginationMode = jsonObject.getString("paginationMode");
            }
        };
    }

    public static String toJSON(DataLayout dataLayout) throws Exception {
        if (!Objects.equals(dataLayout.getPaginationMode(), "pagination") && !Objects.equals(dataLayout.getPaginationMode(), "wizard")) {
            throw new Exception("Pagination mode must be \"pagination\" or \"wizard\"");
        }
        return JSONUtil.put((String)"pages", (Object)JSONUtil.toJSONArray((Object[])dataLayout.getDataLayoutPages(), dataLayoutPage -> DataLayoutUtil._toJSONObject(dataLayoutPage))).put("paginationMode", dataLayout.getPaginationMode()).toString();
    }

    private static DataLayoutColumn _toDataLayoutColumn(final JSONObject jsonObject) {
        return new DataLayoutColumn(){
            {
                this.columnSize = jsonObject.getInt("columnSize");
                this.fieldNames = JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("fieldNames"));
            }
        };
    }

    private static DataLayoutPage _toDataLayoutPage(final JSONObject jsonObject) throws Exception {
        return new DataLayoutPage(){
            {
                this.dataLayoutRows = (DataLayoutRow[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("rows"), rowJSONObject -> DataLayoutUtil._toDataLayoutRow(rowJSONObject), DataLayoutRow.class);
                this.description = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("description"));
                this.title = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("title"));
            }
        };
    }

    private static DataLayoutRow _toDataLayoutRow(final JSONObject jsonObject) throws Exception {
        return new DataLayoutRow(){
            {
                this.dataLayoutColumns = (DataLayoutColumn[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("columns"), columnJSONObject -> DataLayoutUtil._toDataLayoutColumn(columnJSONObject), DataLayoutColumn.class);
            }
        };
    }

    private static JSONObject _toJSONObject(DataLayoutColumn dataLayoutColumn) throws Exception {
        return JSONUtil.put((String)"columnSize", (Object)dataLayoutColumn.getColumnSize()).put("fieldNames", JSONUtil.put((Object[])dataLayoutColumn.getFieldNames()));
    }

    private static JSONObject _toJSONObject(DataLayoutPage dataLayoutPage) throws Exception {
        if (MapUtil.isEmpty((Map)dataLayoutPage.getTitle())) {
            throw new Exception("Title is required");
        }
        return JSONUtil.put((String)"description", (Object)LocalizedValueUtil.toJSONObject((Map)dataLayoutPage.getDescription())).put("rows", JSONUtil.toJSONArray((Object[])dataLayoutPage.getDataLayoutRows(), dataLayoutRow -> DataLayoutUtil._toJSONObject(dataLayoutRow))).put("title", LocalizedValueUtil.toJSONObject((Map)dataLayoutPage.getTitle()));
    }

    private static JSONObject _toJSONObject(DataLayoutRow dataLayoutRow) throws Exception {
        return JSONUtil.put((String)"columns", (Object)JSONUtil.toJSONArray((Object[])dataLayoutRow.getDataLayoutColumns(), dataLayoutColumn -> DataLayoutUtil._toJSONObject(dataLayoutColumn)));
    }
}

