/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.data.engine.rest.dto.v1_0.DataRecord;
import com.liferay.data.engine.rest.dto.v1_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataRecordValuesUtil;
import com.liferay.data.engine.spi.storage.DataStorage;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"data.storage.type=json"}, service={DataStorage.class})
public class JSONDataStorage
implements DataStorage {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMContentLocalService _ddmContentLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    public long delete(long dataStorageId) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.fetchDDMContent(dataStorageId);
        if (ddmContent != null) {
            this._ddmContentLocalService.deleteDDMContent(ddmContent);
        }
        return dataStorageId;
    }

    public Map<String, Object> get(long dataDefinitionId, long dataStorageId) throws Exception {
        DDMContent ddmContent = this._ddmContentLocalService.getContent(dataStorageId);
        return DataRecordValuesUtil.toDataRecordValues(DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(dataDefinitionId)), ddmContent.getData());
    }

    public long save(long dataRecordCollectionId, Map<String, Object> dataRecordValues, final long siteId) throws Exception {
        DataRecordCollection dataRecordCollection = DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId));
        DDMContent ddmContent = this._ddmContentLocalService.addContent(PrincipalThreadLocal.getUserId(), siteId, DataRecord.class.getName(), null, DataRecordValuesUtil.toJSON(DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(dataRecordCollection.getDataDefinitionId().longValue())), dataRecordValues), new ServiceContext(){
            {
                this.setScopeGroupId(siteId);
                this.setUserId(PrincipalThreadLocal.getUserId());
            }
        });
        return ddmContent.getPrimaryKey();
    }
}

