/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionRule;
import com.liferay.data.engine.rest.dto.v1_0.DataRecord;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataRecordResourceImpl;
import com.liferay.data.engine.rest.internal.storage.DataRecordExporter;
import com.liferay.data.engine.rest.internal.storage.DataStorageTracker;
import com.liferay.data.engine.rest.resource.v1_0.DataRecordResource;
import com.liferay.data.engine.spi.rule.function.DataRuleFunction;
import com.liferay.data.engine.spi.rule.function.DataRuleFunctionResult;
import com.liferay.data.engine.spi.rule.function.DataRuleFunctionTracker;
import com.liferay.data.engine.spi.storage.DataStorage;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-record.properties"}, scope=ServiceScope.PROTOTYPE, service={DataRecordResource.class})
public class DataRecordResourceImpl
extends BaseDataRecordResourceImpl {
    private DataRecordExporter _dataRecordExporter;
    @Reference
    private DataRuleFunctionTracker _dataRuleFunctionTracker;
    @Reference
    private DataStorageTracker _dataStorageTracker;
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordService _ddlRecordService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMContentLocalService _ddmContentLocalService;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    private ModelResourcePermission<InternalDataRecordCollection> _modelResourcePermission;
    @Reference
    private Portal _portal;

    @Activate
    public void activate() {
        this._dataRecordExporter = new DataRecordExporter(this._ddlRecordSetLocalService);
    }

    @Override
    public void deleteDataRecord(Long dataRecordId) throws Exception {
        DDLRecord ddlRecord = this._ddlRecordLocalService.getDDLRecord(dataRecordId.longValue());
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddlRecord.getRecordSetId(), "DELETE_DATA_RECORD");
        DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        dataStorage.delete(dataRecordId.longValue());
        this._ddlRecordLocalService.deleteDDLRecord(dataRecordId.longValue());
    }

    @Override
    public DataRecord getDataRecord(Long dataRecordId) throws Exception {
        DDLRecord ddlRecord = this._ddlRecordLocalService.getDDLRecord(dataRecordId.longValue());
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddlRecord.getRecordSetId(), "VIEW_DATA_RECORD");
        return this._toDataRecord(ddlRecord);
    }

    @Override
    public String getDataRecordCollectionDataRecordExport(Long dataRecordCollectionId, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "EXPORT_DATA_RECORDS");
        return this._dataRecordExporter.export(this.transform(this._ddlRecordLocalService.getRecords(dataRecordCollectionId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toDataRecord));
    }

    @Override
    public Page<DataRecord> getDataRecordCollectionDataRecordsPage(Long dataRecordCollectionId, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-cannot-be-bigger-than-x", (Object)250));
        }
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "VIEW_DATA_RECORD");
        return Page.of(this.transform(this._ddlRecordLocalService.getRecords(dataRecordCollectionId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toDataRecord), (Pagination)pagination, (long)this._ddlRecordLocalService.getRecordsCount(dataRecordCollectionId.longValue(), PrincipalThreadLocal.getUserId()));
    }

    @Override
    public DataRecord postDataRecordCollectionDataRecord(Long dataRecordCollectionId, DataRecord dataRecord) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "ADD_DATA_RECORD");
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        dataRecord.setDataRecordCollectionId(dataRecordCollectionId);
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        this._validate(DataDefinitionUtil.toDataDefinition(ddmStructure), dataRecord);
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        return this._toDataRecord(this._ddlRecordLocalService.addRecord(PrincipalThreadLocal.getUserId(), ddlRecordSet.getGroupId(), dataStorage.save(ddlRecordSet.getRecordSetId(), dataRecord.getDataRecordValues(), ddlRecordSet.getGroupId()), dataRecord.getDataRecordCollectionId().longValue(), new ServiceContext()));
    }

    @Override
    public DataRecord putDataRecord(Long dataRecordId, DataRecord dataRecord) throws Exception {
        DDLRecord ddlRecord = this._ddlRecordService.getRecord(dataRecordId.longValue());
        DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddlRecordSet.getRecordSetId(), "UPDATE_DATA_RECORD");
        dataRecord.setDataRecordCollectionId(Long.valueOf(ddlRecordSet.getRecordSetId()));
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        this._validate(DataDefinitionUtil.toDataDefinition(ddmStructure), dataRecord);
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        long ddmStorageId = dataStorage.save(ddlRecordSet.getRecordSetId(), dataRecord.getDataRecordValues(), ddlRecord.getGroupId());
        this._ddlRecordLocalService.updateRecord(PrincipalThreadLocal.getUserId(), dataRecordId.longValue(), ddmStorageId, new ServiceContext());
        DDLRecordSetVersion ddlRecordSetVersion = ddlRecordSet.getRecordSetVersion();
        DDMStructureVersion ddmStructureVersion = ddlRecordSetVersion.getDDMStructureVersion();
        this._ddmStorageLinkLocalService.addStorageLink(this._portal.getClassNameId(DataRecord.class.getName()), ddmStorageId, ddmStructureVersion.getStructureVersionId(), new ServiceContext());
        return dataRecord;
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataRecordCollection> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private DataStorage _getDataStorage(String dataStorageType) {
        if (Validator.isNull((String)dataStorageType)) {
            throw new BadRequestException("Data storage type is null");
        }
        DataStorage dataStorage = this._dataStorageTracker.getDataStorage(dataStorageType);
        if (dataStorage == null) {
            throw new BadRequestException("Unsupported data storage type: " + dataStorageType);
        }
        return dataStorage;
    }

    private DataRecord _toDataRecord(final DDLRecord ddlRecord) throws Exception {
        final DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        final DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        final DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        return new DataRecord(){
            {
                this.dataRecordCollectionId = ddlRecordSet.getRecordSetId();
                this.dataRecordValues = dataStorage.get(ddmStructure.getStructureId(), ddlRecord.getDDMStorageId());
                this.id = ddlRecord.getRecordId();
            }
        };
    }

    private void _validate(DataDefinition dataDefinition, DataRecord dataRecord) throws Exception {
        Set dataDefinitionFieldNames = Stream.of(dataDefinition.getDataDefinitionFields()).map(dataDefinitionField -> dataDefinitionField.getName()).collect(Collectors.toSet());
        Map dataRecordValues = dataRecord.getDataRecordValues();
        Set fieldNames = dataRecordValues.keySet();
        List missingFieldNames = fieldNames.stream().filter(fieldName -> !dataDefinitionFieldNames.contains(fieldName)).collect(Collectors.toList());
        if (!missingFieldNames.isEmpty()) {
            throw new BadRequestException("Missing fields: " + ArrayUtil.toStringArray(missingFieldNames));
        }
        List dataDefinitionRules = Stream.of(dataDefinition.getDataDefinitionRules()).filter(dataDefinitionRule -> Objects.equals(dataDefinitionRule.getRuleType(), "validation")).collect(Collectors.toList());
        if (dataDefinitionRules.isEmpty()) {
            return;
        }
        Map dataDefinitionFields = Stream.of(dataDefinition.getDataDefinitionFields()).collect(Collectors.toMap(DataDefinitionField::getName, Function.identity()));
        HashMap<String, Set> errorCodesMap = new HashMap<String, Set>();
        for (DataDefinitionRule dataDefinitionRule2 : dataDefinitionRules) {
            DataRuleFunction dataRuleFunction = this._dataRuleFunctionTracker.getDataRuleFunction(dataDefinitionRule2.getName());
            if (dataRuleFunction == null) continue;
            for (String dataDefinitionFieldName : dataDefinitionRule2.getDataDefinitionFieldNames()) {
                DataDefinitionField dataDefinitionField2 = (DataDefinitionField)dataDefinitionFields.get(dataDefinitionFieldName);
                DataRuleFunctionResult dataRuleFunctionResult = dataRuleFunction.validate(dataDefinitionRule2.getDataDefinitionRuleParameters(), DataDefinitionFieldUtil.toSPIDataDefinitionField(dataDefinitionField2), dataRecordValues.get(dataDefinitionField2.getName()));
                if (dataRuleFunctionResult.isValid()) continue;
                Set errorCodes = errorCodesMap.getOrDefault(dataDefinitionFieldName, new HashSet());
                errorCodes.add(dataRuleFunctionResult.getErrorCode());
                errorCodesMap.put(dataDefinitionFieldName, errorCodes);
            }
        }
        if (!errorCodesMap.isEmpty()) {
            throw new BadRequestException(((Object)errorCodesMap).toString());
        }
    }
}

