/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataRecordCollection;
import com.liferay.data.engine.rest.dto.v1_0.DataRecordCollectionPermission;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataRecordCollectionResourceImpl;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.data.engine.rest.resource.v1_0.DataRecordCollectionResource;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-record-collection.properties"}, scope=ServiceScope.PROTOTYPE, service={DataRecordCollectionResource.class})
public class DataRecordCollectionResourceImpl
extends BaseDataRecordCollectionResourceImpl {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private ModelResourcePermission<InternalDataRecordCollection> _modelResourcePermission;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public void deleteDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "DELETE");
        this._ddlRecordSetLocalService.deleteRecordSet(dataRecordCollectionId.longValue());
    }

    @Override
    public Page<DataRecordCollection> getDataDefinitionDataRecordCollectionsPage(Long dataDefinitionId, String keywords, Pagination pagination) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddlRecordSetLocalService.getRecordSets(ddmStructure.getGroupId(), pagination.getStartPosition(), pagination.getEndPosition()), DataRecordCollectionUtil::toDataRecordCollection), (Pagination)pagination, (long)this._ddlRecordSetLocalService.getRecordSetsCount(ddmStructure.getGroupId()));
        }
        return Page.of(this.transform(this._ddlRecordSetLocalService.search(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), DataRecordCollectionUtil::toDataRecordCollection), (Pagination)pagination, (long)this._ddlRecordSetLocalService.searchCount(ddmStructure.getCompanyId(), ddmStructure.getGroupId(), keywords, 3));
    }

    @Override
    public DataRecordCollection getDataRecordCollection(Long dataRecordCollectionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "VIEW");
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue()));
    }

    @Override
    public Page<DataRecordCollection> getSiteDataRecordCollectionsPage(Long siteId, String keywords, Pagination pagination) throws Exception {
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddlRecordSetLocalService.getRecordSets(siteId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), DataRecordCollectionUtil::toDataRecordCollection), (Pagination)pagination, (long)this._ddlRecordSetLocalService.getRecordSetsCount(siteId.longValue()));
        }
        Group group = this._groupLocalService.getGroup(siteId.longValue());
        return Page.of(this.transform(this._ddlRecordSetLocalService.search(group.getCompanyId(), siteId.longValue(), keywords, 3, pagination.getStartPosition(), pagination.getEndPosition(), null), DataRecordCollectionUtil::toDataRecordCollection), (Pagination)pagination, (long)this._ddlRecordSetLocalService.searchCount(group.getCompanyId(), siteId.longValue(), keywords, 3));
    }

    @Override
    public DataRecordCollection postDataDefinitionDataRecordCollection(Long dataDefinitionId, DataRecordCollection dataRecordCollection) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkPermission("ADD_DATA_RECORD_COLLECTION", this._groupLocalService, ddmStructure.getGroupId());
        ServiceContext serviceContext = new ServiceContext();
        dataRecordCollection = DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.addRecordSet(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), dataDefinitionId.longValue(), null, LocalizedValueUtil.toLocaleStringMap((Map)dataRecordCollection.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataRecordCollection.getDescription()), 0, 3, serviceContext));
        this._resourceLocalService.addModelResources(this.contextCompany.getCompanyId(), ddmStructure.getGroupId(), PrincipalThreadLocal.getUserId(), InternalDataRecordCollection.class.getName(), dataRecordCollection.getId().longValue(), serviceContext.getModelPermissions());
        return dataRecordCollection;
    }

    @Override
    public void postDataRecordCollectionDataRecordCollectionPermission(Long dataRecordCollectionId, String operation, DataRecordCollectionPermission dataRecordCollectionPermission) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddlRecordSet.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (dataRecordCollectionPermission.getAddDataRecord().booleanValue()) {
            actionIds.add("ADD_DATA_RECORD");
        }
        if (dataRecordCollectionPermission.getDelete().booleanValue()) {
            actionIds.add("DELETE");
        }
        if (dataRecordCollectionPermission.getDeleteDataRecord().booleanValue()) {
            actionIds.add("DELETE_DATA_RECORD");
        }
        if (dataRecordCollectionPermission.getExportDataRecord().booleanValue()) {
            actionIds.add("EXPORT_DATA_RECORDS");
        }
        if (dataRecordCollectionPermission.getUpdate().booleanValue()) {
            actionIds.add("UPDATE");
        }
        if (dataRecordCollectionPermission.getUpdateDataRecord().booleanValue()) {
            actionIds.add("UPDATE_DATA_RECORD");
        }
        if (dataRecordCollectionPermission.getView().booleanValue()) {
            actionIds.add("VIEW");
        }
        if (dataRecordCollectionPermission.getViewDataRecord().booleanValue()) {
            actionIds.add("VIEW_DATA_RECORD");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, this.contextCompany, dataRecordCollectionId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection", this._resourcePermissionLocalService, this._roleLocalService, dataRecordCollectionPermission.getRoleNames(), ddlRecordSet.getGroupId());
    }

    @Override
    public void postSiteDataRecordCollectionPermission(Long siteId, String operation, DataRecordCollectionPermission dataRecordCollectionPermission) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (dataRecordCollectionPermission.getAddDataRecordCollection().booleanValue()) {
            actionIds.add("ADD_DATA_RECORD_COLLECTION");
        }
        if (dataRecordCollectionPermission.getDefinePermissions().booleanValue()) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, this.contextCompany, operation, this._resourcePermissionLocalService, this._roleLocalService, dataRecordCollectionPermission.getRoleNames());
    }

    @Override
    public DataRecordCollection putDataRecordCollection(Long dataRecordCollectionId, DataRecordCollection dataRecordCollection) throws Exception {
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId.longValue(), "UPDATE");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(PrincipalThreadLocal.getUserId());
        return DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.updateRecordSet(dataRecordCollectionId.longValue(), ddlRecordSet.getDDMStructureId(), LocalizedValueUtil.toLocaleStringMap((Map)dataRecordCollection.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataRecordCollection.getDescription()), 0, serviceContext));
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataRecordCollection> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }
}

