/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPermission;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataLayout;
import com.liferay.data.engine.rest.internal.model.InternalDataRecordCollection;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataLayoutResourceImpl;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.data.engine.rest.resource.v1_0.DataLayoutResource;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.StructureLayoutNameComparator;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-layout.properties"}, scope=ServiceScope.PROTOTYPE, service={DataLayoutResource.class})
public class DataLayoutResourceImpl
extends BaseDataLayoutResourceImpl {
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private ModelResourcePermission<InternalDataRecordCollection> _modelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public void deleteDataLayout(Long dataLayoutId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "DELETE");
        this._ddmStructureLayoutLocalService.deleteDDMStructureLayout(dataLayoutId.longValue());
    }

    @Override
    public Page<DataLayout> getDataDefinitionDataLayoutsPage(Long dataDefinitionId, String keywords, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        return Page.of(this.transform(this._ddmStructureLayoutLocalService.search(ddmStructure.getCompanyId(), new long[]{ddmStructure.getGroupId()}, this._getClassNameId(), keywords, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new StructureLayoutNameComparator()), this::_toDataLayout), (Pagination)pagination, (long)this._ddmStructureLayoutLocalService.searchCount(ddmStructure.getCompanyId(), new long[]{ddmStructure.getGroupId()}, this._getClassNameId(), keywords));
    }

    @Override
    public DataLayout getDataLayout(Long dataLayoutId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "VIEW");
        return this._toDataLayout(this._ddmStructureLayoutLocalService.getDDMStructureLayout(dataLayoutId.longValue()));
    }

    @Override
    public Page<DataLayout> getSiteDataLayoutPage(Long siteId, String keywords, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException("Page size is out of limit");
        }
        return Page.of(this.transform(this._ddmStructureLayoutLocalService.search(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId(), keywords, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new StructureLayoutNameComparator()), this::_toDataLayout), (Pagination)pagination, (long)this._ddmStructureLayoutLocalService.searchCount(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId(), keywords));
    }

    @Override
    public DataLayout postDataDefinitionDataLayout(Long dataDefinitionId, DataLayout dataLayout) throws Exception {
        if (MapUtil.isEmpty((Map)dataLayout.getName())) {
            throw new Exception("Name is required");
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkPermission("ADD_DATA_LAYOUT", this._groupLocalService, ddmStructure.getGroupId());
        ServiceContext serviceContext = new ServiceContext();
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.addStructureLayout(PrincipalThreadLocal.getUserId(), ddmStructure.getGroupId(), this._getDDMStructureVersionId(dataDefinitionId), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getDescription()), DataLayoutUtil.toJSON(dataLayout), serviceContext);
        dataLayout.setId(Long.valueOf(ddmStructureLayout.getStructureLayoutId()));
        this._resourceLocalService.addModelResources(this.contextCompany.getCompanyId(), ddmStructure.getGroupId(), PrincipalThreadLocal.getUserId(), InternalDataLayout.class.getName(), dataLayout.getId().longValue(), serviceContext.getModelPermissions());
        return dataLayout;
    }

    @Override
    public void postDataLayoutDataLayoutPermission(Long dataLayoutId, String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddmStructureLayout.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (dataLayoutPermission.getDelete().booleanValue()) {
            actionIds.add("DELETE");
        }
        if (dataLayoutPermission.getUpdate().booleanValue()) {
            actionIds.add("UPDATE");
        }
        if (dataLayoutPermission.getView().booleanValue()) {
            actionIds.add("VIEW");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, this.contextCompany, dataLayoutId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataLayout", this._resourcePermissionLocalService, this._roleLocalService, dataLayoutPermission.getRoleNames(), ddmStructureLayout.getGroupId());
    }

    @Override
    public void postSiteDataLayoutPermission(Long siteId, String operation, DataLayoutPermission dataLayoutPermission) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (dataLayoutPermission.getAddDataLayout().booleanValue()) {
            actionIds.add("ADD_DATA_LAYOUT");
        }
        if (dataLayoutPermission.getDefinePermissions().booleanValue()) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, this.contextCompany, operation, this._resourcePermissionLocalService, this._roleLocalService, dataLayoutPermission.getRoleNames());
    }

    @Override
    public DataLayout putDataLayout(Long dataLayoutId, DataLayout dataLayout) throws Exception {
        if (MapUtil.isEmpty((Map)dataLayout.getName())) {
            throw new Exception("Name is required");
        }
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataLayoutId.longValue(), "UPDATE");
        return this._toDataLayout(this._ddmStructureLayoutLocalService.updateStructureLayout(dataLayoutId.longValue(), this._getDDMStructureVersionId(dataLayout.getDataDefinitionId()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataLayout.getDescription()), DataLayoutUtil.toJSON(dataLayout), new ServiceContext()));
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataLayout)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataRecordCollection> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(InternalDataLayout.class);
    }

    private long _getDDMStructureId(DDMStructureLayout ddmStructureLayout) throws Exception {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        DDMStructure ddmStructure = ddmStructureVersion.getStructure();
        return ddmStructure.getStructureId();
    }

    private long _getDDMStructureVersionId(Long deDataDefinitionId) throws Exception {
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(deDataDefinitionId.longValue());
        return ddmStructureVersion.getStructureVersionId();
    }

    private DataLayout _toDataLayout(DDMStructureLayout ddmStructureLayout) throws Exception {
        DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDefinition());
        dataLayout.setDateCreated(ddmStructureLayout.getCreateDate());
        dataLayout.setDataDefinitionId(Long.valueOf(this._getDDMStructureId(ddmStructureLayout)));
        dataLayout.setId(Long.valueOf(ddmStructureLayout.getStructureLayoutId()));
        dataLayout.setDescription(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getDescriptionMap()));
        dataLayout.setDateModified(ddmStructureLayout.getModifiedDate());
        dataLayout.setName(LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getNameMap()));
        dataLayout.setUserId(Long.valueOf(ddmStructureLayout.getUserId()));
        return dataLayout;
    }
}

