/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionPermission;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.model.InternalDataDefinition;
import com.liferay.data.engine.rest.internal.resource.v1_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.resource.v1_0.util.DataEnginePermissionUtil;
import com.liferay.data.engine.rest.resource.v1_0.DataDefinitionResource;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private ModelResourcePermission<InternalDataDefinition> _modelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "DELETE");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        if (this._ddlRecordSetLocalService.getRecordSetsCount(ddmStructure.getGroupId(), dataDefinitionId.longValue(), false) > 0) {
            throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(dataDefinitionId.longValue());
        }
        List ddmStructureVersions = this._ddmStructureVersionLocalService.getStructureVersions(dataDefinitionId.longValue());
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this._ddmStructureVersionLocalService.deleteDDMStructureVersion(ddmStructureVersion);
        }
        this._ddmStructureLocalService.deleteDDMStructure(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()));
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionsPage(Long siteId, String keywords, Pagination pagination) throws Exception {
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureService.getStructures(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId(), pagination.getStartPosition(), pagination.getEndPosition(), null), DataDefinitionUtil::toDataDefinition), (Pagination)pagination, (long)this._ddmStructureService.getStructuresCount(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId()));
        }
        return Page.of(this.transform(this._ddmStructureService.search(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId(), keywords, -1, pagination.getStartPosition(), pagination.getEndPosition(), null), DataDefinitionUtil::toDataDefinition), (Pagination)pagination, (long)this._ddmStructureService.searchCount(this.contextCompany.getCompanyId(), new long[]{siteId}, this._getClassNameId(), keywords, -1));
    }

    @Override
    public void postDataDefinitionDataDefinitionPermission(Long dataDefinitionId, String operation, DataDefinitionPermission dataDefinitionPermission) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, ddmStructure.getGroupId());
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getDelete())) {
            actionIds.add("DELETE");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getUpdate())) {
            actionIds.add("UPDATE");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getView())) {
            actionIds.add("VIEW");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistModelPermission(actionIds, this.contextCompany, dataDefinitionId, operation, "com.liferay.data.engine.rest.internal.model.InternalDataDefinition", this._resourcePermissionLocalService, this._roleLocalService, dataDefinitionPermission.getRoleNames(), ddmStructure.getGroupId());
    }

    @Override
    public DataDefinition postSiteDataDefinition(Long siteId, DataDefinition dataDefinition) throws Exception {
        DataEnginePermissionUtil.checkPermission("ADD_DATA_DEFINITION", this._groupLocalService, siteId);
        ServiceContext serviceContext = new ServiceContext();
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, this._getClassNameId(), null, LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), DataDefinitionUtil.toJSON(dataDefinition), dataDefinition.getStorageType(), serviceContext));
        this._resourceLocalService.addModelResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), InternalDataDefinition.class.getName(), dataDefinition.getId().longValue(), serviceContext.getModelPermissions());
        return dataDefinition;
    }

    @Override
    public void postSiteDataDefinitionPermission(Long siteId, String operation, DataDefinitionPermission dataDefinitionPermission) throws Exception {
        DataEnginePermissionUtil.checkOperationPermission(this._groupLocalService, operation, siteId);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getAddDataDefinition())) {
            actionIds.add("ADD_DATA_DEFINITION");
        }
        if (GetterUtil.getBoolean((Object)dataDefinitionPermission.getDefinePermissions())) {
            actionIds.add("DEFINE_PERMISSIONS");
        }
        if (actionIds.isEmpty()) {
            return;
        }
        DataEnginePermissionUtil.persistPermission(actionIds, this.contextCompany, operation, this._resourcePermissionLocalService, this._roleLocalService, dataDefinitionPermission.getRoleNames());
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId.longValue(), "UPDATE");
        return DataDefinitionUtil.toDataDefinition(this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), 0L, LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), DataDefinitionUtil.toJSON(dataDefinition), new ServiceContext()));
    }

    @Reference(target="(model.class.name=com.liferay.data.engine.rest.internal.model.InternalDataDefinition)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<InternalDataDefinition> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private long _getClassNameId() {
        return this._portal.getClassNameId(InternalDataDefinition.class);
    }
}

