/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.renderer.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v1_0.DataLayoutRow;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionFieldUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataLayoutUtil;
import com.liferay.data.engine.spi.field.type.FieldType;
import com.liferay.data.engine.spi.field.type.FieldTypeTracker;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.spi.renderer.DataLayoutRenderer;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.template.soy.renderer.ComponentDescriptor;
import com.liferay.portal.template.soy.renderer.SoyComponentRenderer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DataLayoutRenderer.class})
public class DataLayoutRendererImpl
implements DataLayoutRenderer {
    private static final String _MODULE_NAME = "dynamic-data-mapping-form-renderer/js/metal/containers/Form/Form.es";
    private static final String _TEMPLATE_NAMESPACE = "FormRenderer.render";
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private FieldTypeTracker _fieldTypeTracker;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private SoyComponentRenderer _soyComponentRenderer;

    public String render(Long dataLayoutId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        ComponentDescriptor componentDescriptor = new ComponentDescriptor(_TEMPLATE_NAMESPACE, this._npmResolver.resolveModuleName(_MODULE_NAME));
        HashMap<String, Object> context = new HashMap<String, Object>();
        DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(dataLayoutId.longValue());
        DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getDDMStructureVersion(ddmStructureLayout.getStructureVersionId());
        DataLayout dataLayout = DataLayoutUtil.toDataLayout(ddmStructureLayout.getDefinition());
        context.put("pages", this._createDataLayoutPageContexts(this._getDataDefinitionFieldsMap(DataDefinitionUtil.toDataDefinition(ddmStructureVersion.getStructure())), dataLayout.getDataLayoutPages(), this._fieldTypeTracker, httpServletRequest, httpServletResponse));
        context.put("paginationMode", dataLayout.getPaginationMode());
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String pathThemeImages = themeDisplay.getPathThemeImages();
        context.put("spritemap", pathThemeImages.concat("/clay/icons.svg"));
        this._soyComponentRenderer.renderSoyComponent(httpServletRequest, (Writer)writer, componentDescriptor, context);
        return writer.toString();
    }

    private List<Object> _createDataLayoutColumnContexts(Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutColumn[] dataLayoutColumns, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList<Object> dataLayoutColumnContexts = new ArrayList<Object>();
        for (DataLayoutColumn dataLayoutColumn : dataLayoutColumns) {
            HashMap<String, Object> dataLayoutColumnsContext = new HashMap<String, Object>();
            dataLayoutColumnsContext.put("fields", this._createFieldTypeContexts(dataDefinitionFields, dataLayoutColumn.getFieldNames(), fieldTypeTracker, httpServletRequest, httpServletResponse));
            dataLayoutColumnsContext.put("size", dataLayoutColumn.getColumnSize());
            dataLayoutColumnContexts.add(dataLayoutColumnsContext);
        }
        return dataLayoutColumnContexts;
    }

    private List<Object> _createDataLayoutPageContexts(Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutPage[] dataLayoutPages, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList<Object> dataLayoutPageContexts = new ArrayList<Object>();
        for (DataLayoutPage dataLayoutPage : dataLayoutPages) {
            HashMap<String, Object> dataLayoutPageContext = new HashMap<String, Object>();
            dataLayoutPageContext.put("description", GetterUtil.getString((Object)LocalizedValueUtil.getLocalizedValue((Locale)httpServletRequest.getLocale(), (Map)dataLayoutPage.getDescription())));
            dataLayoutPageContext.put("rows", this._createDataLayoutRowContexts(dataDefinitionFields, dataLayoutPage.getDataLayoutRows(), fieldTypeTracker, httpServletRequest, httpServletResponse));
            dataLayoutPageContext.put("title", GetterUtil.getString((Object)LocalizedValueUtil.getLocalizedValue((Locale)httpServletRequest.getLocale(), (Map)dataLayoutPage.getTitle())));
            dataLayoutPageContexts.add(dataLayoutPageContext);
        }
        return dataLayoutPageContexts;
    }

    private List<Object> _createDataLayoutRowContexts(Map<String, DataDefinitionField> dataDefinitionFields, DataLayoutRow[] dataLayoutRows, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList<Object> dataLayoutRowContexts = new ArrayList<Object>();
        for (DataLayoutRow dataLayoutRow : dataLayoutRows) {
            HashMap<String, List<Object>> dataLayoutRowContext = new HashMap<String, List<Object>>();
            dataLayoutRowContext.put("columns", this._createDataLayoutColumnContexts(dataDefinitionFields, dataLayoutRow.getDataLayoutColums(), fieldTypeTracker, httpServletRequest, httpServletResponse));
            dataLayoutRowContexts.add(dataLayoutRowContext);
        }
        return dataLayoutRowContexts;
    }

    private List<Object> _createFieldTypeContexts(Map<String, DataDefinitionField> dataDefinitionFields, String[] fieldNames, FieldTypeTracker fieldTypeTracker, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList<Object> fieldTypeContexts = new ArrayList<Object>();
        for (String fieldName : fieldNames) {
            DataDefinitionField dataDefinitionField = dataDefinitionFields.get(fieldName);
            FieldType fieldType = fieldTypeTracker.getFieldType(dataDefinitionField.getFieldType());
            if (fieldType == null) continue;
            fieldTypeContexts.add(fieldType.includeContext(httpServletRequest, httpServletResponse, DataDefinitionFieldUtil.toSPIDataDefinitionField(dataDefinitionField)));
        }
        return fieldTypeContexts;
    }

    private Map<String, DataDefinitionField> _getDataDefinitionFieldsMap(DataDefinition dataDefinition) {
        List<DataDefinitionField> dataDefinitionFields = Arrays.asList(dataDefinition.getDataDefinitionFields());
        Stream stream = dataDefinitionFields.stream();
        return stream.collect(Collectors.toMap(field -> field.getName(), Function.identity()));
    }
}

