/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.graphql.query.v1_0;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataLayout;
import com.liferay.data.engine.rest.dto.v1_0.DataRecord;
import com.liferay.data.engine.rest.dto.v1_0.DataRecordCollection;
import com.liferay.data.engine.rest.resource.v1_0.DataDefinitionResource;
import com.liferay.data.engine.rest.resource.v1_0.DataLayoutResource;
import com.liferay.data.engine.rest.resource.v1_0.DataRecordCollectionResource;
import com.liferay.data.engine.rest.resource.v1_0.DataRecordResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLInvokeDetached;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Collection;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<DataDefinitionResource> _dataDefinitionResourceComponentServiceObjects;
    private static ComponentServiceObjects<DataLayoutResource> _dataLayoutResourceComponentServiceObjects;
    private static ComponentServiceObjects<DataRecordResource> _dataRecordResourceComponentServiceObjects;
    private static ComponentServiceObjects<DataRecordCollectionResource> _dataRecordCollectionResourceComponentServiceObjects;

    public static void setDataDefinitionResourceComponentServiceObjects(ComponentServiceObjects<DataDefinitionResource> dataDefinitionResourceComponentServiceObjects) {
        _dataDefinitionResourceComponentServiceObjects = dataDefinitionResourceComponentServiceObjects;
    }

    public static void setDataLayoutResourceComponentServiceObjects(ComponentServiceObjects<DataLayoutResource> dataLayoutResourceComponentServiceObjects) {
        _dataLayoutResourceComponentServiceObjects = dataLayoutResourceComponentServiceObjects;
    }

    public static void setDataRecordResourceComponentServiceObjects(ComponentServiceObjects<DataRecordResource> dataRecordResourceComponentServiceObjects) {
        _dataRecordResourceComponentServiceObjects = dataRecordResourceComponentServiceObjects;
    }

    public static void setDataRecordCollectionResourceComponentServiceObjects(ComponentServiceObjects<DataRecordCollectionResource> dataRecordCollectionResourceComponentServiceObjects) {
        _dataRecordCollectionResourceComponentServiceObjects = dataRecordCollectionResourceComponentServiceObjects;
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public DataDefinition getDataDefinition(@GraphQLName(value="dataDefinitionId") Long dataDefinitionId) throws Exception {
        return (DataDefinition)this._applyComponentServiceObjects(_dataDefinitionResourceComponentServiceObjects, this::_populateResourceContext, dataDefinitionResource -> dataDefinitionResource.getDataDefinition(dataDefinitionId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataDefinition> getSiteDataDefinitionsPage(@GraphQLName(value="siteId") Long siteId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataDefinitionResourceComponentServiceObjects, this::_populateResourceContext, dataDefinitionResource -> {
            Page paginationPage = dataDefinitionResource.getSiteDataDefinitionsPage(siteId, keywords, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataLayout> getDataDefinitionDataLayoutsPage(@GraphQLName(value="dataDefinitionId") Long dataDefinitionId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataLayoutResourceComponentServiceObjects, this::_populateResourceContext, dataLayoutResource -> {
            Page paginationPage = dataLayoutResource.getDataDefinitionDataLayoutsPage(dataDefinitionId, keywords, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public DataLayout getDataLayout(@GraphQLName(value="dataLayoutId") Long dataLayoutId) throws Exception {
        return (DataLayout)this._applyComponentServiceObjects(_dataLayoutResourceComponentServiceObjects, this::_populateResourceContext, dataLayoutResource -> dataLayoutResource.getDataLayout(dataLayoutId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataLayout> getSiteDataLayoutPage(@GraphQLName(value="siteId") Long siteId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataLayoutResourceComponentServiceObjects, this::_populateResourceContext, dataLayoutResource -> {
            Page paginationPage = dataLayoutResource.getSiteDataLayoutPage(siteId, keywords, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataRecord> getDataRecordCollectionDataRecordsPage(@GraphQLName(value="dataRecordCollectionId") Long dataRecordCollectionId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataRecordResourceComponentServiceObjects, this::_populateResourceContext, dataRecordResource -> {
            Page paginationPage = dataRecordResource.getDataRecordCollectionDataRecordsPage(dataRecordCollectionId, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public String getDataRecordCollectionDataRecordExport(@GraphQLName(value="dataRecordCollectionId") Long dataRecordCollectionId, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (String)this._applyComponentServiceObjects(_dataRecordResourceComponentServiceObjects, this::_populateResourceContext, dataRecordResource -> dataRecordResource.getDataRecordCollectionDataRecordExport(dataRecordCollectionId, Pagination.of((int)pageSize, (int)page)));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public DataRecord getDataRecord(@GraphQLName(value="dataRecordId") Long dataRecordId) throws Exception {
        return (DataRecord)this._applyComponentServiceObjects(_dataRecordResourceComponentServiceObjects, this::_populateResourceContext, dataRecordResource -> dataRecordResource.getDataRecord(dataRecordId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataRecordCollection> getDataDefinitionDataRecordCollectionsPage(@GraphQLName(value="dataDefinitionId") Long dataDefinitionId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataRecordCollectionResourceComponentServiceObjects, this::_populateResourceContext, dataRecordCollectionResource -> {
            Page paginationPage = dataRecordCollectionResource.getDataDefinitionDataRecordCollectionsPage(dataDefinitionId, keywords, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public DataRecordCollection getDataRecordCollection(@GraphQLName(value="dataRecordCollectionId") Long dataRecordCollectionId) throws Exception {
        return (DataRecordCollection)this._applyComponentServiceObjects(_dataRecordCollectionResourceComponentServiceObjects, this::_populateResourceContext, dataRecordCollectionResource -> dataRecordCollectionResource.getDataRecordCollection(dataRecordCollectionId));
    }

    @GraphQLField
    @GraphQLInvokeDetached
    public Collection<DataRecordCollection> getSiteDataRecordCollectionsPage(@GraphQLName(value="siteId") Long siteId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page) throws Exception {
        return (Collection)this._applyComponentServiceObjects(_dataRecordCollectionResourceComponentServiceObjects, this::_populateResourceContext, dataRecordCollectionResource -> {
            Page paginationPage = dataRecordCollectionResource.getSiteDataRecordCollectionsPage(siteId, keywords, Pagination.of((int)pageSize, (int)page));
            return paginationPage.getItems();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(DataDefinitionResource dataDefinitionResource) throws Exception {
        dataDefinitionResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(DataLayoutResource dataLayoutResource) throws Exception {
        dataLayoutResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(DataRecordResource dataRecordResource) throws Exception {
        dataRecordResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }

    private void _populateResourceContext(DataRecordCollectionResource dataRecordCollectionResource) throws Exception {
        dataRecordCollectionResource.setContextCompany(CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getCompanyId()));
    }
}

