/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0.util;

import com.liferay.data.engine.rest.internal.field.type.v1_0.DataFieldOption;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataFieldOptionUtil {
    public static List<DataFieldOption> toDataFieldOptions(JSONObject jsonObject) {
        ArrayList<DataFieldOption> dataFieldOptions = new ArrayList<DataFieldOption>();
        if (jsonObject == null) {
            return dataFieldOptions;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Map localizationMap = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject(key));
            DataFieldOption dataFieldOption = new DataFieldOption(localizationMap, key);
            dataFieldOptions.add(dataFieldOption);
        }
        return dataFieldOptions;
    }

    public static List<DataFieldOption> toDataFieldOptions(List<DataFieldOption> dataFieldOptions, String languageId) {
        if (ListUtil.isEmpty(dataFieldOptions)) {
            return Collections.emptyList();
        }
        Stream stream = dataFieldOptions.stream();
        return stream.map(dataFieldOption -> new DataFieldOption(dataFieldOption.getLabel(languageId), languageId, dataFieldOption.getValue())).collect(Collectors.toList());
    }

    public static JSONObject toJSONObject(List<DataFieldOption> dataFieldOptions) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (ListUtil.isEmpty(dataFieldOptions)) {
            return jsonObject;
        }
        for (DataFieldOption dataFieldOption : dataFieldOptions) {
            JSONObject labelJSONObject = JSONFactoryUtil.createJSONObject();
            Map<String, Object> labels = dataFieldOption.getLabels();
            for (Map.Entry<String, Object> entry : labels.entrySet()) {
                labelJSONObject.put(entry.getKey(), entry.getValue());
            }
            jsonObject.put(dataFieldOption.getValue(), labelJSONObject);
        }
        return jsonObject;
    }
}

