/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0;

import com.liferay.data.engine.rest.internal.field.type.v1_0.util.CustomPropertiesUtil;
import com.liferay.data.engine.spi.field.type.BaseFieldType;
import com.liferay.data.engine.spi.field.type.FieldType;
import com.liferay.data.engine.spi.field.type.SPIDataDefinitionField;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"data.engine.field.type.data.domain=number", "data.engine.field.type.description=numeric-field-type-description", "data.engine.field.type.display.order:Integer=8", "data.engine.field.type.group=customized", "data.engine.field.type.icon=caret-double", "data.engine.field.type.js.module=dynamic-data-mapping-form-field-type/metal/Numeric/Numeric.es", "data.engine.field.type.label=numeric-field-type-label"}, service={FieldType.class})
public class NumericFieldType
extends BaseFieldType {
    public SPIDataDefinitionField deserialize(JSONObject jsonObject) throws Exception {
        SPIDataDefinitionField spiDataDefinitionField = super.deserialize(jsonObject);
        Map customProperties = spiDataDefinitionField.getCustomProperties();
        customProperties.put("dataType", jsonObject.getString("dataType"));
        customProperties.put("placeholder", LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("placeholder")));
        customProperties.put("predefinedValue", LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("predefinedValue")));
        customProperties.put("tooltip", LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("tooltip")));
        return spiDataDefinitionField;
    }

    public String getName() {
        return "numeric";
    }

    public JSONObject toJSONObject(SPIDataDefinitionField spiDataDefinitionField) throws Exception {
        JSONObject jsonObject = super.toJSONObject(spiDataDefinitionField);
        jsonObject.put("dataType", MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"dataType")).put("placeholder", LocalizedValueUtil.toJSONObject(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "placeholder"))).put("predefinedValue", LocalizedValueUtil.toJSONObject(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "predefinedValue"))).put("tooltip", LocalizedValueUtil.toJSONObject(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "tooltip")));
        return jsonObject;
    }

    protected void includeContext(Map<String, Object> context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SPIDataDefinitionField spiDataDefinitionField) {
        context.put("dataType", MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"dataType", (String)"decimal"));
        context.put("placeholder", MapUtil.getString(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "placeholder"), (String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest)));
        context.put("predefinedValue", this._format(MapUtil.getString(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "predefinedValue"), (String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest)), httpServletRequest));
        context.put("symbols", this._getSymbols(httpServletRequest));
        context.put("tooltip", MapUtil.getString(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "placeholder"), (String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest)));
        context.put("value", this._format(MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"value"), httpServletRequest));
    }

    private String _format(Object value, HttpServletRequest httpServletRequest) {
        if (Validator.isNull((Object)value) || StringUtil.equals((String)((String)value), (String)"NaN")) {
            return "";
        }
        DecimalFormat decimalFormat = this._getDecimalFormat(httpServletRequest);
        return decimalFormat.format(GetterUtil.getNumber((Object)value));
    }

    private DecimalFormat _getDecimalFormat(HttpServletRequest httpServletRequest) {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(httpServletRequest.getLocale());
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat;
    }

    private Map<String, String> _getSymbols(HttpServletRequest httpServletRequest) {
        DecimalFormat decimalFormat = this._getDecimalFormat(httpServletRequest);
        final DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return new HashMap<String, String>(){
            {
                this.put("decimalSymbol", String.valueOf(decimalFormatSymbols.getDecimalSeparator()));
                this.put("thousandsSeparator", String.valueOf(decimalFormatSymbols.getGroupingSeparator()));
            }
        };
    }
}

