/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0;

import com.liferay.data.engine.spi.field.type.FieldType;
import com.liferay.data.engine.spi.field.type.FieldTypeTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={FieldTypeTracker.class})
public class FieldTypeTrackerImpl
implements FieldTypeTracker {
    private final Map<String, FieldType> _fieldTypes = new TreeMap<String, FieldType>();
    private final Map<String, Map<String, Object>> _fieldTypesProperties = new TreeMap<String, Map<String, Object>>();

    public FieldType getFieldType(String name) {
        return this._fieldTypes.get(name);
    }

    public Map<String, Object> getFieldTypeProperties(String name) {
        return Optional.ofNullable(this._fieldTypesProperties.get(name)).orElse(Collections.emptyMap());
    }

    public Collection<FieldType> getFieldTypes() {
        return Collections.unmodifiableCollection(this._fieldTypes.values());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addFieldType(FieldType fieldType, Map<String, Object> properties) {
        String name = fieldType.getName();
        this._fieldTypes.put(name, fieldType);
        this._fieldTypesProperties.put(name, Collections.unmodifiableMap(properties));
    }

    @Deactivate
    protected void deactivate() {
        this._fieldTypes.clear();
        this._fieldTypesProperties.clear();
    }

    protected void removeFieldType(FieldType fieldType, Map<String, Object> properties) {
        String name = fieldType.getName();
        this._fieldTypes.remove(name);
        this._fieldTypesProperties.remove(name);
    }
}

