/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0;

import com.liferay.data.engine.rest.internal.field.type.v1_0.util.CustomPropertiesUtil;
import com.liferay.data.engine.spi.field.type.BaseFieldType;
import com.liferay.data.engine.spi.field.type.FieldType;
import com.liferay.data.engine.spi.field.type.SPIDataDefinitionField;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"data.engine.field.type.icon=icon-font", "data.engine.field.type.system=true"}, service={FieldType.class})
public class FieldSetFieldType
extends BaseFieldType {
    private static final int _COLUMN_SIZE_FULL = 12;

    public String getName() {
        return "fieldset";
    }

    protected void includeContext(Map<String, Object> context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SPIDataDefinitionField spiDataDefinitionField) {
        Map<String, List<Object>> map = CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "nestedFields");
        if (!map.isEmpty()) {
            List<Object> nestedFields = FieldSetFieldType._getNestedFields(map, this._getNestedFieldNames(CustomPropertiesUtil.getString(spiDataDefinitionField.getCustomProperties(), "nestedFieldNames"), map.keySet()));
            context.put("columnSize", this._getColumnSize(nestedFields.size(), CustomPropertiesUtil.getString(spiDataDefinitionField.getCustomProperties(), "orientation", "horizontal")));
            context.put("nestedFields", nestedFields);
        }
        if (context.containsKey("label")) {
            context.put("showLabel", true);
        }
    }

    private static List<Object> _getNestedFields(Map<String, List<Object>> nestedFieldsMap, Set<String> nestedFieldNames) {
        Set<Map.Entry<String, List<Object>>> entrySet = nestedFieldsMap.entrySet();
        Stream stream = entrySet.stream();
        return stream.filter(entry -> nestedFieldNames.contains(entry.getKey())).map(entry -> (List)entry.getValue()).collect(Collectors.toList());
    }

    private int _getColumnSize(int nestedFieldsSize, String orientation) {
        if (Objects.equals(orientation, "vertical")) {
            return 12;
        }
        if (nestedFieldsSize == 0) {
            return 0;
        }
        return 12 / nestedFieldsSize;
    }

    private Set<String> _getNestedFieldNames(String nestedFieldNames, Set<String> defaultNestedFieldNames) {
        if (Validator.isNotNull((String)nestedFieldNames)) {
            return Stream.of(StringUtil.split((String)nestedFieldNames)).collect(Collectors.toSet());
        }
        return defaultNestedFieldNames;
    }
}

