/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.field.type.v1_0;

import com.liferay.data.engine.rest.internal.field.type.v1_0.util.CustomPropertiesUtil;
import com.liferay.data.engine.spi.field.type.BaseFieldType;
import com.liferay.data.engine.spi.field.type.FieldType;
import com.liferay.data.engine.spi.field.type.SPIDataDefinitionField;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"data.engine.field.type.description=document-library-field-type-description", "data.engine.field.type.display.order:Integer=9", "data.engine.field.type.group=customized", "data.engine.field.type.icon=upload", "data.engine.field.type.js.module=dynamic-data-mapping-form-field-type/metal/DocumentLibrary/DocumentLibrary.es", "data.engine.field.type.label=document-library-field-type-label"}, service={FieldType.class})
public class DocumentLibraryFieldType
extends BaseFieldType {
    private static final Log _log = LogFactoryUtil.getLog(DocumentLibraryFieldType.class);
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private Html _html;
    @Reference
    private Portal _portal;

    public SPIDataDefinitionField deserialize(JSONObject jsonObject) throws Exception {
        SPIDataDefinitionField spiDataDefinitionField = super.deserialize(jsonObject);
        Map customProperties = spiDataDefinitionField.getCustomProperties();
        customProperties.put("groupId", jsonObject.getLong("groupId"));
        customProperties.put("itemSelectorAuthToken", jsonObject.getString("itemSelectorAuthToken"));
        customProperties.put("lexiconIconsPath", jsonObject.getString("lexiconIconsPath"));
        customProperties.put("strings", CustomPropertiesUtil.toMap(jsonObject.getJSONObject("strings")));
        return spiDataDefinitionField;
    }

    public String getName() {
        return "document_library";
    }

    public JSONObject toJSONObject(SPIDataDefinitionField spiDataDefinitionField) throws Exception {
        JSONObject jsonObject = super.toJSONObject(spiDataDefinitionField);
        return jsonObject.put("groupId", MapUtil.getLong((Map)spiDataDefinitionField.getCustomProperties(), (String)"groupId")).put("itemSelectorAuthToken", MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"itemSelectorAuthToken")).put("lexiconIconsPath", MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"lexiconIconsPath")).put("strings", CustomPropertiesUtil.toJSONObject(CustomPropertiesUtil.getMap(spiDataDefinitionField.getCustomProperties(), "strings")));
    }

    protected void includeContext(Map<String, Object> context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SPIDataDefinitionField spiDataDefinitionField) {
        JSONObject valueJSONObject;
        if (!StringUtils.isEmpty((String)MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"value")) && (valueJSONObject = this._toJSONObject(CustomPropertiesUtil.getString(spiDataDefinitionField.getCustomProperties(), "value"))) != null && valueJSONObject.length() > 0) {
            FileEntry fileEntry = this._getFileEntry(valueJSONObject);
            context.put("fileEntryTitle", this._getFileEntryTitle(fileEntry));
            context.put("fileEntryURL", this._getFileEntryURL(fileEntry, httpServletRequest));
        }
        context.put("groupId", MapUtil.getLong((Map)spiDataDefinitionField.getCustomProperties(), (String)"groupId"));
        context.put("itemSelectorAuthToken", this._getItemSelectorAuthToken(httpServletRequest));
        context.put("lexiconIconsPath", this._getLexiconIconsPath(httpServletRequest));
        context.put("strings", this._getStrings(httpServletRequest));
        context.put("value", JSONFactoryUtil.looseDeserialize((String)MapUtil.getString((Map)spiDataDefinitionField.getCustomProperties(), (String)"value", (String)"{}")));
    }

    private FileEntry _getFileEntry(JSONObject valueJSONObject) {
        try {
            return this._dlAppService.getFileEntryByUuidAndGroupId(valueJSONObject.getString("uuid"), valueJSONObject.getLong("groupId"));
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to retrieve file entry ", (Throwable)pe);
            return null;
        }
    }

    private String _getFileEntryTitle(FileEntry fileEntry) {
        if (fileEntry == null) {
            return "";
        }
        return this._html.escape(fileEntry.getTitle());
    }

    private String _getFileEntryURL(FileEntry fileEntry, HttpServletRequest httpServletRequest) {
        if (fileEntry == null) {
            return "";
        }
        StringBundler sb = new StringBundler(9);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)this._html.unescape(fileEntry.getTitle()), (boolean)true));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        return this._html.escape(sb.toString());
    }

    private String _getItemSelectorAuthToken(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return "";
        }
        try {
            return AuthTokenUtil.getToken((HttpServletRequest)httpServletRequest, (long)this._portal.getControlPanelPlid(themeDisplay.getCompanyId()), (String)"com_liferay_item_selector_web_portlet_ItemSelectorPortlet");
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to generate item selector auth token ", (Throwable)pe);
            return "";
        }
    }

    private String _getLexiconIconsPath(HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(3);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPathThemeImages());
        sb.append("/lexicon/icons.svg");
        sb.append("#");
        return sb.toString();
    }

    private Map<String, String> _getStrings(HttpServletRequest httpServletRequest) {
        HashMap<String, String> values = new HashMap<String, String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AggregateResourceBundle resourceBundle = new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), ((Object)((Object)this)).getClass()), this._portal.getResourceBundle(themeDisplay.getLocale())});
        values.put("select", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"select"));
        return values;
    }

    private JSONObject _toJSONObject(String string) {
        try {
            return JSONFactoryUtil.createJSONObject((String)string);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsone, (Throwable)jsone);
            }
            return null;
        }
    }
}

