/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v1_0.util;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DataRecordValuesUtil {
    public static Map<String, Object> toDataRecordValues(DataDefinition dataDefinition, String json) throws Exception {
        HashMap<String, Object> dataRecordValues = new HashMap<String, Object>();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        for (DataDefinitionField dataDefinitionField : dataDefinition.getDataDefinitionFields()) {
            if (!jsonObject.has(dataDefinitionField.getName())) continue;
            dataRecordValues.put(dataDefinitionField.getName(), DataRecordValuesUtil._toDataRecordValue(dataDefinitionField, jsonObject));
        }
        return dataRecordValues;
    }

    public static String toJSON(DataDefinition dataDefinition, Map<String, ?> dataRecordValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map dataDefinitionFields = Stream.of(dataDefinition.getDataDefinitionFields()).collect(Collectors.toMap(dataDefinitionField -> dataDefinitionField.getName(), Function.identity()));
        for (Map.Entry entry : dataDefinitionFields.entrySet()) {
            if (!dataRecordValues.containsKey(entry.getKey())) continue;
            DataDefinitionField dataDefinitionField2 = (DataDefinitionField)entry.getValue();
            if (dataDefinitionField2.getLocalizable().booleanValue()) {
                jsonObject.put(entry.getKey(), DataRecordValuesUtil._toJSONObject((Map)dataRecordValues.get(dataDefinitionField2.getName())));
                continue;
            }
            if (dataDefinitionField2.getRepeatable().booleanValue()) {
                jsonObject.put(entry.getKey(), JSONFactoryUtil.createJSONArray((Object[])((Object[])dataRecordValues.get(entry.getKey()))));
                continue;
            }
            jsonObject.put(entry.getKey(), dataRecordValues.get(entry.getKey()));
        }
        return jsonObject.toString();
    }

    private static Object _toDataRecordValue(DataDefinitionField dataDefinitionField, JSONObject jsonObject) {
        if (dataDefinitionField.getLocalizable().booleanValue()) {
            HashMap localizedValues = new HashMap();
            JSONObject dataRecordValueJSONObject = jsonObject.getJSONObject(dataDefinitionField.getName());
            Iterable iterable = () -> ((JSONObject)dataRecordValueJSONObject).keys();
            StreamSupport.stream(iterable.spliterator(), false).forEach(key -> localizedValues.put(key, dataRecordValueJSONObject.get(key)));
            return localizedValues;
        }
        if (dataDefinitionField.getRepeatable().booleanValue()) {
            return JSONUtil.toObjectArray((JSONArray)jsonObject.getJSONArray(dataDefinitionField.getName()));
        }
        return jsonObject.get(dataDefinitionField.getName());
    }

    private static JSONObject _toJSONObject(Map<String, Object> localizedValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry<String, Object> entry : localizedValues.entrySet()) {
            jsonObject.put(entry.getKey(), GetterUtil.get((Object)entry.getValue(), (String)""));
        }
        return jsonObject;
    }
}

