/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v1_0.util;

import com.liferay.data.engine.rest.dto.v1_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v1_0.DataDefinitionRule;
import com.liferay.data.engine.rest.internal.dto.v1_0.util.DataDefinitionRuleParameterUtil;
import com.liferay.data.engine.spi.field.type.util.LocalizedValueUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class DataDefinitionUtil {
    public static DataDefinition toDataDefinition(final DDMStructure ddmStructure) throws Exception {
        final JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)ddmStructure.getDefinition());
        return new DataDefinition(){
            {
                this.dataDefinitionFields = (DataDefinitionField[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("fields"), fieldJSONObject -> DataDefinitionUtil._toDataDefinitionField(fieldJSONObject), DataDefinitionField.class);
                this.dataDefinitionRules = (DataDefinitionRule[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("rules"), ruleJSONObject -> DataDefinitionUtil._toDataDefinitionRule(ruleJSONObject), DataDefinitionRule.class);
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.description = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap());
                this.id = ddmStructure.getStructureId();
                this.name = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap());
                this.siteId = ddmStructure.getGroupId();
                this.storageType = ddmStructure.getStorageType();
                this.userId = ddmStructure.getUserId();
            }
        };
    }

    public static String toJSON(DataDefinition dataDefinition) throws Exception {
        return JSONUtil.put((String)"fields", (Object)JSONUtil.toJSONArray((Object[])dataDefinition.getDataDefinitionFields(), dataDefinitionField -> DataDefinitionUtil._toJSONObject(dataDefinitionField))).put("rules", JSONUtil.toJSONArray((Object[])dataDefinition.getDataDefinitionRules(), dataDefinitionRule -> DataDefinitionUtil._toJSONObject(dataDefinitionRule))).toString();
    }

    private static DataDefinitionField _toDataDefinitionField(final JSONObject jsonObject) throws Exception {
        return new DataDefinitionField(){
            {
                if (jsonObject.has("predefinedValue")) {
                    this.defaultValue = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("predefinedValue"));
                }
                if (!jsonObject.has("type")) {
                    throw new Exception("Type is required");
                }
                this.fieldType = jsonObject.getString("type");
                this.indexable = jsonObject.getBoolean("indexable", true);
                if (!jsonObject.has("label")) {
                    throw new Exception("Label is required");
                }
                this.label = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("label"));
                this.localizable = jsonObject.getBoolean("localizable", false);
                if (!jsonObject.has("name")) {
                    throw new Exception("Name is required");
                }
                this.name = jsonObject.getString("name");
                this.repeatable = jsonObject.getBoolean("repeatable", false);
                if (!jsonObject.has("tip")) {
                    throw new Exception("Tip is required");
                }
                this.tip = LocalizedValueUtil.toLocalizedValues((JSONObject)jsonObject.getJSONObject("tip"));
            }
        };
    }

    private static DataDefinitionRule _toDataDefinitionRule(final JSONObject jsonObject) {
        return new DataDefinitionRule(){
            {
                this.dataDefinitionFieldNames = JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("fields"));
                this.dataDefinitionRuleParameters = DataDefinitionRuleParameterUtil.toDataDefinitionRuleParameters(jsonObject.getJSONObject("parameters"));
                this.name = jsonObject.getString("name");
                this.ruleType = jsonObject.getString("ruleType");
            }
        };
    }

    private static JSONObject _toJSONObject(DataDefinitionField dataDefinitionField) throws Exception {
        String name = dataDefinitionField.getName();
        if (Validator.isNull((String)name)) {
            throw new Exception("Name is required");
        }
        String type = dataDefinitionField.getFieldType();
        if (type == null || type.isEmpty()) {
            throw new Exception("Type is required");
        }
        return JSONUtil.put((String)"defaultValue", (Object)dataDefinitionField.getDefaultValue()).put("indexable", (Object)dataDefinitionField.getIndexable()).put("label", LocalizedValueUtil.toJSONObject((Map)dataDefinitionField.getLabel())).put("localizable", (Object)dataDefinitionField.getLocalizable()).put("name", name).put("repeatable", (Object)dataDefinitionField.getRepeatable()).put("tip", LocalizedValueUtil.toJSONObject((Map)dataDefinitionField.getTip())).put("type", type);
    }

    private static JSONObject _toJSONObject(DataDefinitionRule dataDefinitionRule) throws Exception {
        return JSONUtil.put((String)"fields", (Object)JSONFactoryUtil.createJSONArray((Object[])dataDefinitionRule.getDataDefinitionFieldNames())).put("name", dataDefinitionRule.getName()).put("parameters", DataDefinitionRuleParameterUtil.toJSONObject(dataDefinitionRule.getDataDefinitionRuleParameters())).put("ruleType", dataDefinitionRule.getRuleType());
    }
}

