/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.client.resource.v2_0;

import com.liferay.data.engine.rest.client.dto.v2_0.DataDefinitionFieldLink;
import com.liferay.data.engine.rest.client.http.HttpInvoker;
import com.liferay.data.engine.rest.client.pagination.Page;
import com.liferay.data.engine.rest.client.problem.Problem;
import com.liferay.data.engine.rest.client.serdes.v2_0.DataDefinitionFieldLinkSerDes;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface DataDefinitionFieldLinkResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<DataDefinitionFieldLink> getDataDefinitionDataDefinitionFieldLinkPage(Long var1, String var2) throws Exception;

    public HttpInvoker.HttpResponse getDataDefinitionDataDefinitionFieldLinkPageHttpResponse(Long var1, String var2) throws Exception;

    public static class DataDefinitionFieldLinkResourceImpl
    implements DataDefinitionFieldLinkResource {
        private static final Logger _logger = Logger.getLogger(DataDefinitionFieldLinkResource.class.getName());
        private Builder _builder;

        @Override
        public Page<DataDefinitionFieldLink> getDataDefinitionDataDefinitionFieldLinkPage(Long dataDefinitionId, String fieldName) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getDataDefinitionDataDefinitionFieldLinkPageHttpResponse(dataDefinitionId, fieldName);
            String content = httpResponse.getContent();
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, DataDefinitionFieldLinkSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getDataDefinitionDataDefinitionFieldLinkPageHttpResponse(Long dataDefinitionId, String fieldName) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (fieldName != null) {
                httpInvoker.parameter("fieldName", String.valueOf(fieldName));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + "/o/data-engine/v2.0/data-definitions/{dataDefinitionId}/data-definition-field-links", dataDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private DataDefinitionFieldLinkResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public DataDefinitionFieldLinkResource build() {
            return new DataDefinitionFieldLinkResourceImpl(this);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        private Builder() {
        }
    }
}

