/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.dto.v2_0.util;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.util.SettingsDDMFormFieldsUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataDefinitionDDMFormUtil {
    private static final String[] _PREDEFINED_PROPERTIES = new String[]{"indexType", "label", "localizable", "name", "predefinedValue", "readOnly", "repeatable", "required", "showLabel", "tip", "type"};
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionDDMFormUtil.class);

    public static DDMForm toDDMForm(DataDefinition dataDefinition, DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry) {
        if (dataDefinition == null) {
            return new DDMForm();
        }
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(DataDefinitionDDMFormUtil._toLocales(dataDefinition.getAvailableLanguageIds()));
        ddmForm.setDDMFormFields(DataDefinitionDDMFormUtil._toDDMFormFields(dataDefinition.getDataDefinitionFields(), ddmFormFieldTypeServicesRegistry, dataDefinition.getDefaultLanguageId()));
        ddmForm.setDefaultLocale(LocaleUtil.fromLanguageId((String)dataDefinition.getDefaultLanguageId()));
        return ddmForm;
    }

    private static void _addOption(DDMFormFieldOptions ddmFormFieldOptions, JSONObject jsonObject, Locale locale) {
        ddmFormFieldOptions.addOptionLabel(JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"Object/value"}), locale, JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"Object/label"}));
        ddmFormFieldOptions.addOptionReference(JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"Object/value"}), JSONUtil.getValueAsString((Object)jsonObject, (String[])new String[]{"Object/reference"}));
    }

    private static DDMFormFieldOptions _getDDMFormFieldOptions(Locale locale, Map<String, ?> options) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        if (MapUtil.isEmpty(options)) {
            return ddmFormFieldOptions;
        }
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            Object value = entry.getValue();
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                Object[] values;
                for (Object curValue : values = (Object[])value) {
                    try {
                        JSONObject jsonObject = null;
                        jsonObject = curValue instanceof Map ? JSONFactoryUtil.createJSONObject((Map)((Map)curValue)) : JSONFactoryUtil.createJSONObject((String)curValue.toString());
                        ddmFormFieldOptions.addOptionLabel(jsonObject.getString("value"), LocaleUtil.fromLanguageId((String)entry.getKey()), jsonObject.getString("label"));
                        ddmFormFieldOptions.addOptionReference(jsonObject.getString("value"), jsonObject.getString("reference"));
                    }
                    catch (JSONException jsonException) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)jsonException);
                    }
                }
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object option : (List)value) {
                if (option instanceof JSONObject) {
                    DataDefinitionDDMFormUtil._addOption(ddmFormFieldOptions, (JSONObject)option, LocaleUtil.fromLanguageId((String)entry.getKey()));
                    continue;
                }
                if (option instanceof Map) {
                    ddmFormFieldOptions.addOptionLabel(MapUtil.getString((Map)((Map)option), (String)"value"), LocaleUtil.fromLanguageId((String)entry.getKey()), MapUtil.getString((Map)((Map)option), (String)"label"));
                    ddmFormFieldOptions.addOptionReference(MapUtil.getString((Map)((Map)option), (String)"value"), MapUtil.getString((Map)((Map)option), (String)"reference"));
                    continue;
                }
                if (!(option instanceof String)) continue;
                try {
                    JSONObject optionJSONObject = JSONFactoryUtil.createJSONObject((String)option.toString());
                    DataDefinitionDDMFormUtil._addOption(ddmFormFieldOptions, optionJSONObject, LocaleUtil.fromLanguageId((String)entry.getKey()));
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)jsonException);
                }
            }
        }
        ddmFormFieldOptions.setDefaultLocale(locale);
        return ddmFormFieldOptions;
    }

    private static DDMFormFieldValidation _getDDMFormFieldValidation(Map<String, Object> value) {
        if (MapUtil.isEmpty(value)) {
            return null;
        }
        final Map expression = (Map)value.get("expression");
        if (Validator.isNull((String)MapUtil.getString((Map)expression, (String)"value"))) {
            return null;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
            {
                this.setName(MapUtil.getString((Map)expression, (String)"name"));
                this.setValue(MapUtil.getString((Map)expression, (String)"value"));
            }
        });
        ddmFormFieldValidation.setErrorMessageLocalizedValue(LocalizedValueUtil.toLocalizedValue((Map)((Map)value.get("errorMessage"))));
        ddmFormFieldValidation.setParameterLocalizedValue(LocalizedValueUtil.toLocalizedValue((Map)((Map)value.get("parameter"))));
        return ddmFormFieldValidation;
    }

    private static DDMFormField _toDDMFormField(DataDefinitionField dataDefinitionField, DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry, String languageId) {
        DDMFormField ddmFormField = new DDMFormField();
        ddmFormField.setIndexType(dataDefinitionField.getIndexTypeAsString());
        ddmFormField.setLabel(LocalizedValueUtil.toLocalizedValue(dataDefinitionField.getLabel(), (Locale)LocaleUtil.fromLanguageId((String)languageId)));
        ddmFormField.setLocalizable(GetterUtil.getBoolean((Object)dataDefinitionField.getLocalizable()));
        ddmFormField.setName(dataDefinitionField.getName());
        ddmFormField.setNestedDDMFormFields(DataDefinitionDDMFormUtil._toDDMFormFields(dataDefinitionField.getNestedDataDefinitionFields(), ddmFormFieldTypeServicesRegistry, languageId));
        ddmFormField.setPredefinedValue(LocalizedValueUtil.toLocalizedValue(dataDefinitionField.getDefaultValue(), (Locale)LocaleUtil.fromLanguageId((String)languageId)));
        ddmFormField.setReadOnly(GetterUtil.getBoolean((Object)dataDefinitionField.getReadOnly()));
        ddmFormField.setRepeatable(GetterUtil.getBoolean((Object)dataDefinitionField.getRepeatable()));
        ddmFormField.setRequired(GetterUtil.getBoolean((Object)dataDefinitionField.getRequired()));
        ddmFormField.setShowLabel(GetterUtil.getBoolean((Object)dataDefinitionField.getShowLabel(), (boolean)true));
        ddmFormField.setTip(LocalizedValueUtil.toLocalizedValue(dataDefinitionField.getTip(), (Locale)LocaleUtil.fromLanguageId((String)languageId)));
        ddmFormField.setType(dataDefinitionField.getFieldType());
        Map<String, Object> customProperties = dataDefinitionField.getCustomProperties();
        if (MapUtil.isNotEmpty(customProperties)) {
            Map settingsDDMFormFieldsMap = SettingsDDMFormFieldsUtil.getSettingsDDMFormFields((DDMFormFieldTypeServicesRegistry)ddmFormFieldTypeServicesRegistry, (String)dataDefinitionField.getFieldType());
            for (Map.Entry<String, Object> entry : customProperties.entrySet()) {
                DDMFormField settingsDDMFormField;
                if (ArrayUtil.contains((Object[])_PREDEFINED_PROPERTIES, (Object)entry.getKey()) || (settingsDDMFormField = (DDMFormField)settingsDDMFormFieldsMap.get(entry.getKey())) == null) continue;
                if (settingsDDMFormField.isLocalizable()) {
                    ddmFormField.setProperty(entry.getKey(), (Object)LocalizedValueUtil.toLocalizedValue((Map)((Map)entry.getValue()), (Locale)LocaleUtil.fromLanguageId((String)languageId)));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getDataType(), "boolean")) {
                    ddmFormField.setProperty(entry.getKey(), (Object)GetterUtil.getBoolean((Object)entry.getValue()));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getDataType(), "ddm-options")) {
                    ddmFormField.setProperty(entry.getKey(), (Object)DataDefinitionDDMFormUtil._getDDMFormFieldOptions(LocaleUtil.fromLanguageId((String)languageId), (Map)entry.getValue()));
                    continue;
                }
                if (Objects.equals(settingsDDMFormField.getType(), "validation")) {
                    ddmFormField.setProperty(entry.getKey(), (Object)DataDefinitionDDMFormUtil._getDDMFormFieldValidation((Map)entry.getValue()));
                    continue;
                }
                ddmFormField.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return ddmFormField;
    }

    private static List<DDMFormField> _toDDMFormFields(DataDefinitionField[] dataDefinitionFields, DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry, String languageId) {
        if (ArrayUtil.isEmpty((Object[])dataDefinitionFields)) {
            return Collections.emptyList();
        }
        return Stream.of(dataDefinitionFields).map(dataDefinitionField -> DataDefinitionDDMFormUtil._toDDMFormField(dataDefinitionField, ddmFormFieldTypeServicesRegistry, languageId)).collect(Collectors.toList());
    }

    private static Set<Locale> _toLocales(String[] languageIds) {
        if (ArrayUtil.isEmpty((Object[])languageIds)) {
            return Collections.emptySet();
        }
        return Stream.of(languageIds).map(LocaleUtil::fromLanguageId).collect(Collectors.toSet());
    }
}

