Liferay.Loader.define('data-engine-js-components-web$moment@2.29.4/src/locale/sl', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        //! moment.js locale configuration
        //! locale : Slovenian [sl]
        //! author : Robert Sedovšek : https://github.com/sedovsek

        import moment from '../moment';

        function processRelativeTime(number, withoutSuffix, key, isFuture) {
            var result = number + ' ';
            switch (key) {
                case 's':
                    return withoutSuffix || isFuture ? 'nekaj sekund' : 'nekaj sekundami';
                case 'ss':
                    if (number === 1) {
                        result += withoutSuffix ? 'sekundo' : 'sekundi';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'sekundi' : 'sekundah';
                    } else if (number < 5) {
                        result += withoutSuffix || isFuture ? 'sekunde' : 'sekundah';
                    } else {
                        result += 'sekund';
                    }
                    return result;
                case 'm':
                    return withoutSuffix ? 'ena minuta' : 'eno minuto';
                case 'mm':
                    if (number === 1) {
                        result += withoutSuffix ? 'minuta' : 'minuto';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'minuti' : 'minutama';
                    } else if (number < 5) {
                        result += withoutSuffix || isFuture ? 'minute' : 'minutami';
                    } else {
                        result += withoutSuffix || isFuture ? 'minut' : 'minutami';
                    }
                    return result;
                case 'h':
                    return withoutSuffix ? 'ena ura' : 'eno uro';
                case 'hh':
                    if (number === 1) {
                        result += withoutSuffix ? 'ura' : 'uro';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'uri' : 'urama';
                    } else if (number < 5) {
                        result += withoutSuffix || isFuture ? 'ure' : 'urami';
                    } else {
                        result += withoutSuffix || isFuture ? 'ur' : 'urami';
                    }
                    return result;
                case 'd':
                    return withoutSuffix || isFuture ? 'en dan' : 'enim dnem';
                case 'dd':
                    if (number === 1) {
                        result += withoutSuffix || isFuture ? 'dan' : 'dnem';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'dni' : 'dnevoma';
                    } else {
                        result += withoutSuffix || isFuture ? 'dni' : 'dnevi';
                    }
                    return result;
                case 'M':
                    return withoutSuffix || isFuture ? 'en mesec' : 'enim mesecem';
                case 'MM':
                    if (number === 1) {
                        result += withoutSuffix || isFuture ? 'mesec' : 'mesecem';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'meseca' : 'mesecema';
                    } else if (number < 5) {
                        result += withoutSuffix || isFuture ? 'mesece' : 'meseci';
                    } else {
                        result += withoutSuffix || isFuture ? 'mesecev' : 'meseci';
                    }
                    return result;
                case 'y':
                    return withoutSuffix || isFuture ? 'eno leto' : 'enim letom';
                case 'yy':
                    if (number === 1) {
                        result += withoutSuffix || isFuture ? 'leto' : 'letom';
                    } else if (number === 2) {
                        result += withoutSuffix || isFuture ? 'leti' : 'letoma';
                    } else if (number < 5) {
                        result += withoutSuffix || isFuture ? 'leta' : 'leti';
                    } else {
                        result += withoutSuffix || isFuture ? 'let' : 'leti';
                    }
                    return result;
            }
        }

        export default moment.defineLocale('sl', {
            months: 'januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december'.split('_'),
            monthsShort: 'jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.'.split('_'),
            monthsParseExact: true,
            weekdays: 'nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota'.split('_'),
            weekdaysShort: 'ned._pon._tor._sre._čet._pet._sob.'.split('_'),
            weekdaysMin: 'ne_po_to_sr_če_pe_so'.split('_'),
            weekdaysParseExact: true,
            longDateFormat: {
                LT: 'H:mm',
                LTS: 'H:mm:ss',
                L: 'DD. MM. YYYY',
                LL: 'D. MMMM YYYY',
                LLL: 'D. MMMM YYYY H:mm',
                LLLL: 'dddd, D. MMMM YYYY H:mm'
            },
            calendar: {
                sameDay: '[danes ob] LT',
                nextDay: '[jutri ob] LT',

                nextWeek: function () {
                    switch (this.day()) {
                        case 0:
                            return '[v] [nedeljo] [ob] LT';
                        case 3:
                            return '[v] [sredo] [ob] LT';
                        case 6:
                            return '[v] [soboto] [ob] LT';
                        case 1:
                        case 2:
                        case 4:
                        case 5:
                            return '[v] dddd [ob] LT';
                    }
                },
                lastDay: '[včeraj ob] LT',
                lastWeek: function () {
                    switch (this.day()) {
                        case 0:
                            return '[prejšnjo] [nedeljo] [ob] LT';
                        case 3:
                            return '[prejšnjo] [sredo] [ob] LT';
                        case 6:
                            return '[prejšnjo] [soboto] [ob] LT';
                        case 1:
                        case 2:
                        case 4:
                        case 5:
                            return '[prejšnji] dddd [ob] LT';
                    }
                },
                sameElse: 'L'
            },
            relativeTime: {
                future: 'čez %s',
                past: 'pred %s',
                s: processRelativeTime,
                ss: processRelativeTime,
                m: processRelativeTime,
                mm: processRelativeTime,
                h: processRelativeTime,
                hh: processRelativeTime,
                d: processRelativeTime,
                dd: processRelativeTime,
                M: processRelativeTime,
                MM: processRelativeTime,
                y: processRelativeTime,
                yy: processRelativeTime
            },
            dayOfMonthOrdinalParse: /\d{1,2}\./,
            ordinal: '%d.',
            week: {
                dow: 1, // Monday is the first day of the week.
                doy: 7 // The week that contains Jan 7th is the first week of the year.
            }
        });
    }
});
//# sourceMappingURL=sl.js.map