/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.space.apio.internal.architect.resource;

import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.CollectionResource;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.content.space.apio.architect.util.ContentSpaceUtil;
import com.liferay.folder.apio.architect.identifier.RootFolderIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.comparator.GroupIdComparator;
import com.liferay.site.apio.architect.identifier.WebSiteIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CollectionResource.class})
public class ContentSpaceCollectionResource
implements CollectionResource<Group, Long, ContentSpaceIdentifier> {
    @Reference
    private GroupLocalService _groupLocalService;

    public CollectionRoutes<Group, Long> collectionRoutes(CollectionRoutes.Builder<Group, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class, AcceptLanguage.class).build();
    }

    public String getName() {
        return "content-space";
    }

    public ItemRoutes<Group, Long> itemRoutes(ItemRoutes.Builder<Group, Long> builder) {
        return builder.addGetter(this::_getGroup).build();
    }

    public Representor<Group> representor(Representor.Builder<Group, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("ContentSpace", new String[0]).identifier(GroupModel::getGroupId).addLinkedModel("creator", PersonIdentifier.class, GroupModel::getCreatorUserId)).addLinkedModel("documentsRepository", RootFolderIdentifier.class, GroupModel::getGroupId)).addLinkedModel("webSite", WebSiteIdentifier.class, GroupModel::getGroupId)).addLocalizedStringByLocale("description", GroupModel::getDescription)).addLocalizedStringByLocale("name", ContentSpaceUtil::getName)).addStringList("availableLanguages", group -> Arrays.asList(LocaleUtil.toW3cLanguageIds((String[])group.getAvailableLanguageIds())))).build();
    }

    private Group _getGroup(long groupId) throws PortalException {
        return this._groupLocalService.getGroup(groupId);
    }

    private PageItems<Group> _getPageItems(Pagination pagination, Company company, AcceptLanguage acceptLanguage) {
        List groups = this._groupLocalService.getActiveGroups(company.getCompanyId(), true, true, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new GroupIdComparator(true));
        int count = this._groupLocalService.getActiveGroupsCount(company.getCompanyId(), true, true);
        return new PageItems((Collection)groups, count);
    }
}

