/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.blogs.internal.item;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.content.dashboard.blogs.internal.item.BlogsEntryContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItemFactory;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderRegistry;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactory;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtypeFactoryRegistry;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Portal;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ContentDashboardItemFactory.class})
public class BlogsEntryContentDashboardItemFactory
implements ContentDashboardItemFactory<BlogsEntry> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference
    private ContentDashboardItemActionProviderRegistry _contentDashboardItemActionProviderRegistry;
    @Reference
    private ContentDashboardItemSubtypeFactoryRegistry _contentDashboardItemSubtypeFactoryRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public ContentDashboardItem<BlogsEntry> create(long classPK) throws PortalException {
        BlogsEntry blogsEntry = this._blogsEntryLocalService.getBlogsEntry(classPK);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(BlogsEntry.class.getName(), blogsEntry.getEntryId());
        if (assetEntry == null) {
            throw new NoSuchModelException("Unable to find an asset entry for blogs entry " + blogsEntry.getEntryId());
        }
        return new BlogsEntryContentDashboardItem(assetEntry.getCategories(), assetEntry.getTags(), blogsEntry, this._contentDashboardItemActionProviderRegistry, this._groupLocalService.fetchGroup(blogsEntry.getGroupId()), this._language, this._portal);
    }

    public Optional<ContentDashboardItemSubtypeFactory> getContentDashboardItemSubtypeFactoryOptional() {
        return this._contentDashboardItemSubtypeFactoryRegistry.getContentDashboardItemSubtypeFactoryOptional(BlogsEntry.class.getName());
    }
}

