/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.content.dashboard.blogs.internal.item;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.content.dashboard.item.ContentDashboardItem;
import com.liferay.content.dashboard.item.ContentDashboardItemVersion;
import com.liferay.content.dashboard.item.action.ContentDashboardItemAction;
import com.liferay.content.dashboard.item.action.ContentDashboardItemActionProviderRegistry;
import com.liferay.content.dashboard.item.action.exception.ContentDashboardItemActionException;
import com.liferay.content.dashboard.item.action.provider.ContentDashboardItemActionProvider;
import com.liferay.content.dashboard.item.type.ContentDashboardItemSubtype;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class BlogsEntryContentDashboardItem
implements ContentDashboardItem<BlogsEntry> {
    private static final Log _log = LogFactoryUtil.getLog(BlogsEntryContentDashboardItem.class);
    private final List<AssetCategory> _assetCategories;
    private final List<AssetTag> _assetTags;
    private final BlogsEntry _blogsEntry;
    private final ContentDashboardItemActionProviderRegistry _contentDashboardItemActionProviderRegistry;
    private final Group _group;
    private final Language _language;
    private final Portal _portal;

    public BlogsEntryContentDashboardItem(List<AssetCategory> assetCategories, List<AssetTag> assetTags, BlogsEntry blogsEntry, ContentDashboardItemActionProviderRegistry contentDashboardItemActionProviderRegistry, Group group, Language language, Portal portal) {
        this._assetCategories = ListUtil.isEmpty(assetCategories) ? Collections.emptyList() : Collections.unmodifiableList(assetCategories);
        this._assetTags = ListUtil.isEmpty(assetTags) ? Collections.emptyList() : Collections.unmodifiableList(assetTags);
        this._blogsEntry = blogsEntry;
        this._contentDashboardItemActionProviderRegistry = contentDashboardItemActionProviderRegistry;
        this._group = group;
        this._language = language;
        this._portal = portal;
    }

    public List<AssetCategory> getAssetCategories() {
        return this._assetCategories;
    }

    public List<AssetCategory> getAssetCategories(long assetVocabularyId) {
        Stream stream = this._assetCategories.stream();
        return stream.filter(assetCategory -> assetCategory.getVocabularyId() == assetVocabularyId).collect(Collectors.toList());
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Locale> getAvailableLocales() {
        return Collections.emptyList();
    }

    public List<ContentDashboardItemAction> getContentDashboardItemActions(HttpServletRequest httpServletRequest, ContentDashboardItemAction.Type ... types) {
        List contentDashboardItemActionProviders = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviders(BlogsEntry.class.getName(), types);
        Stream stream = contentDashboardItemActionProviders.stream();
        return stream.map(contentDashboardItemActionProvider -> {
            try {
                return Optional.ofNullable(contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._blogsEntry, httpServletRequest));
            }
            catch (ContentDashboardItemActionException contentDashboardItemActionException) {
                _log.error((Throwable)contentDashboardItemActionException);
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public ContentDashboardItemSubtype getContentDashboardItemSubtype() {
        return null;
    }

    public Date getCreateDate() {
        return this._blogsEntry.getCreateDate();
    }

    public ContentDashboardItemAction getDefaultContentDashboardItemAction(HttpServletRequest httpServletRequest) {
        long userId = this._portal.getUserId(httpServletRequest);
        Locale locale = this._portal.getLocale(httpServletRequest);
        ContentDashboardItemVersion version = this._getLastContentDashboardItemVersion(locale);
        if (this.getUserId() == userId && Objects.equals(version.getLabel(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)2)))) {
            Optional contentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviderOptional(BlogsEntry.class.getName(), ContentDashboardItemAction.Type.EDIT);
            return contentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElse(null);
        }
        Optional viewContentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviderOptional(BlogsEntry.class.getName(), ContentDashboardItemAction.Type.VIEW);
        return viewContentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElseGet(() -> {
            Optional editContentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviderOptional(BlogsEntry.class.getName(), ContentDashboardItemAction.Type.EDIT);
            return editContentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> this._toContentDashboardItemAction((ContentDashboardItemActionProvider)contentDashboardItemActionProvider, httpServletRequest)).orElse(null);
        });
    }

    public Locale getDefaultLocale() {
        try {
            return this._portal.getSiteDefaultLocale(this._blogsEntry.getGroupId());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return LocaleUtil.getDefault();
        }
    }

    public String getDescription(Locale locale) {
        return this._blogsEntry.getSubtitle();
    }

    public InfoItemReference getInfoItemReference() {
        return new InfoItemReference(BlogsEntry.class.getName(), this._blogsEntry.getEntryId());
    }

    public List<ContentDashboardItemVersion> getLatestContentDashboardItemVersions(Locale locale) {
        return Collections.singletonList(new ContentDashboardItemVersion(null, null, this._blogsEntry.getCreateDate(), this._language.get(locale, WorkflowConstants.getStatusLabel((int)this._blogsEntry.getStatus())), null, WorkflowConstants.getStatusStyle((int)this._blogsEntry.getStatus()), this._blogsEntry.getUserName(), "1.0"));
    }

    public Date getModifiedDate() {
        return this._blogsEntry.getModifiedDate();
    }

    public String getScopeName(Locale locale) {
        return Optional.ofNullable(this._group).map(group -> {
            try {
                return Optional.ofNullable(group.getDescriptiveName(locale)).orElseGet(() -> group.getName(locale));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return group.getName(locale);
            }
        }).orElse("");
    }

    public Map<String, Object> getSpecificInformation(Locale locale) {
        return HashMapBuilder.put((Object)"display-date", (Object)this._blogsEntry.getDisplayDate()).build();
    }

    public String getTitle(Locale locale) {
        return this._blogsEntry.getTitle();
    }

    public String getTypeLabel(Locale locale) {
        InfoItemClassDetails infoItemClassDetails = new InfoItemClassDetails(BlogsEntry.class.getName());
        return infoItemClassDetails.getLabel(locale);
    }

    public long getUserId() {
        return this._blogsEntry.getUserId();
    }

    public String getUserName() {
        return this._blogsEntry.getUserName();
    }

    public boolean isViewable(HttpServletRequest httpServletRequest) {
        Optional contentDashboardItemActionProviderOptional = this._contentDashboardItemActionProviderRegistry.getContentDashboardItemActionProviderOptional(BlogsEntry.class.getName(), ContentDashboardItemAction.Type.VIEW);
        return contentDashboardItemActionProviderOptional.map(contentDashboardItemActionProvider -> contentDashboardItemActionProvider.isShow((Object)this._blogsEntry, httpServletRequest)).orElse(false);
    }

    private ContentDashboardItemVersion _getLastContentDashboardItemVersion(Locale locale) {
        List<ContentDashboardItemVersion> contentDashboardItemVersions = this.getLatestContentDashboardItemVersions(locale);
        return contentDashboardItemVersions.get(contentDashboardItemVersions.size() - 1);
    }

    private ContentDashboardItemAction _toContentDashboardItemAction(ContentDashboardItemActionProvider contentDashboardItemActionProvider, HttpServletRequest httpServletRequest) {
        try {
            return contentDashboardItemActionProvider.getContentDashboardItemAction((Object)this._blogsEntry, httpServletRequest);
        }
        catch (ContentDashboardItemActionException contentDashboardItemActionException) {
            _log.error((Throwable)contentDashboardItemActionException);
            return null;
        }
    }
}

