/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.search;

import com.liferay.configuration.admin.category.ConfigurationCategory;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedAttributeDefinition;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"index.on.startup=false"}, service={ConfigurationModelIndexer.class, Indexer.class})
public class ConfigurationModelIndexer
extends BaseIndexer<ConfigurationModel> {
    @Reference
    private ConfigurationEntryRetriever _configurationEntryRetriever;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public String getClassName() {
        return ConfigurationModel.class.getName();
    }

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            BooleanFilter fullQueryBooleanFilter = new BooleanFilter();
            fullQueryBooleanFilter.addRequiredTerm("entryClassName", this.getClassName());
            BooleanQuery fullQuery = this.createFullQuery(fullQueryBooleanFilter, searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            Hits hits = this.doSearch(searchContext);
            this.processHits(searchContext, hits);
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.setCommitImmediately(false);
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "description", "entryClassName", "title", "uid", "configurationModelAttributeDescription", "configurationModelAttributeName", "configurationModelFactoryPid", "configurationModelId"});
        this.setFilterSearch(false);
        this.setPermissionAware(false);
        this.setSelectAllLocales(false);
        this.setStagingAware(false);
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        this.addSearchLocalizedTerm((BooleanQuery)searchQuery, searchContext, "configurationCategory", false);
        this.addSearchLocalizedTerm((BooleanQuery)searchQuery, searchContext, "description", false);
        this.addSearchLocalizedTerm((BooleanQuery)searchQuery, searchContext, "title", false);
        this.addSearchLocalizedTerm((BooleanQuery)searchQuery, searchContext, "configurationModelAttributeDescription", false);
        this.addSearchLocalizedTerm((BooleanQuery)searchQuery, searchContext, "configurationModelAttributeName", false);
        this.addSearchTerm((BooleanQuery)searchQuery, searchContext, "configurationModelFactoryPid", false);
        this.addSearchTerm((BooleanQuery)searchQuery, searchContext, "configurationModelId", false);
        BooleanQueryImpl fullBooleanQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullBooleanQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        fullBooleanQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        return fullBooleanQuery;
    }

    protected void doDelete(ConfigurationModel configurationModel) throws Exception {
        Document document = this.newDocument();
        document.addUID("com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", configurationModel.getFactoryPid());
        this._indexWriterHelper.deleteDocument(this.getSearchEngineId(), 0L, document.get("uid"), this.isCommitImmediately());
    }

    protected Document doGetDocument(ConfigurationModel configurationModel) throws Exception {
        Document document = this.newDocument();
        document.addUID("com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", configurationModel.getFactoryPid());
        document.addKeyword("configurationModelFactoryPid", configurationModel.getFactoryPid());
        document.addKeyword("configurationModelId", configurationModel.getID());
        document.addKeyword("companyId", 0L);
        document.addKeyword("entryClassName", this.getClassName());
        ExtendedAttributeDefinition[] requiredAttributeDefinitions = configurationModel.getAttributeDefinitions(-1);
        ArrayList<String> attributeNames = new ArrayList<String>(requiredAttributeDefinitions.length);
        ArrayList<String> attributeDescriptions = new ArrayList<String>(requiredAttributeDefinitions.length);
        for (ExtendedAttributeDefinition attributeDefinition : requiredAttributeDefinitions) {
            attributeNames.add(attributeDefinition.getName());
            attributeDescriptions.add(attributeDefinition.getDescription());
        }
        ResourceBundleLoader resourceBundleLoader = this._resourceBundleLoaderProvider.getResourceBundleLoader(configurationModel.getBundleSymbolicName());
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String fieldNameSuffix = StringBundler.concat((String[])new String[]{"_", locale.getLanguage(), "_", locale.getCountry()});
            List<String> descriptionValues = this._getLocalizedValues(attributeDescriptions, resourceBundleLoader, locale);
            document.addText("configurationModelAttributeDescription" + fieldNameSuffix, descriptionValues.toArray(new String[0]));
            List<String> nameValues = this._getLocalizedValues(attributeNames, resourceBundleLoader, locale);
            document.addKeyword("configurationModelAttributeName" + fieldNameSuffix, nameValues.toArray(new String[0]));
        }
        ArrayList<TranslationHelper> translationHelpers = new ArrayList<TranslationHelper>(3);
        ConfigurationCategory configurationCategory = this._configurationEntryRetriever.getConfigurationCategory(configurationModel.getCategory());
        if (configurationCategory != null) {
            translationHelpers.add(new TranslationHelper("category." + configurationModel.getCategory(), "configurationCategory"));
        }
        translationHelpers.add(new TranslationHelper(configurationModel.getDescription(), "description"));
        translationHelpers.add(new TranslationHelper(configurationModel.getName(), "title"));
        this._addLocalizedText(document, resourceBundleLoader, translationHelpers);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(ConfigurationModel configurationModel) throws Exception {
        Document document = this.getDocument(configurationModel);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), 0L, document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
    }

    protected void doReindex(String[] ids) throws Exception {
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        for (ConfigurationModel configurationModel : configurationModels.values()) {
            this.doReindex(configurationModel);
        }
    }

    private void _addLocalizedText(Document document, ResourceBundleLoader resourceBundleLoader, List<TranslationHelper> translationHelpers) {
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            for (TranslationHelper translationHelper : translationHelpers) {
                ResourceBundle resourceBundle = this._getResourceBundle(locale, resourceBundleLoader);
                if (resourceBundle == null) continue;
                translationHelper.accept(resourceBundle, locale);
            }
        }
        for (TranslationHelper translationHelper : translationHelpers) {
            document.addLocalizedText(translationHelper._name, translationHelper._values);
        }
    }

    private List<String> _getLocalizedValues(List<String> attributeDescriptions, ResourceBundleLoader resourceBundleLoader, Locale locale) {
        ArrayList<String> values = new ArrayList<String>(attributeDescriptions.size());
        for (String attributeDescription : attributeDescriptions) {
            String value;
            ResourceBundle resourceBundle;
            if (Validator.isNull((String)attributeDescription) || (resourceBundle = this._getResourceBundle(locale, resourceBundleLoader)) == null || Validator.isNull((String)(value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)attributeDescription)))) continue;
            values.add(value);
        }
        return values;
    }

    private ResourceBundle _getResourceBundle(Locale locale, ResourceBundleLoader resourceBundleLoader) {
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        return resourceBundleLoader.loadResourceBundle(LocaleUtil.getDefault());
    }

    private static class TranslationHelper {
        private final String _key;
        private final String _name;
        private final Map<Locale, String> _values = new HashMap<Locale, String>();

        public void accept(ResourceBundle resourceBundle, Locale locale) {
            String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)this._key);
            if (Validator.isNotNull((String)value)) {
                this._values.put(locale, value);
            }
        }

        private TranslationHelper(String key, String name) {
            this._key = GetterUtil.getString((String)key);
            this._name = name;
        }
    }
}

