/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.search;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.search.ConfigurationModelIndexer;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelIterator;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchException;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class ConfigurationIndexingExtender {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationIndexingExtender.class);
    private BundleTracker<ConfigurationModelIterator> _bundleTracker;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private ConfigurationModelIndexer _configurationModelIndexer;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new ConfigurationModelsBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    protected void commit(Indexer<ConfigurationModel> indexer) {
        block2: {
            try {
                this._indexWriterHelper.commit(indexer.getSearchEngineId());
            }
            catch (SearchException se) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to commit", (Throwable)se);
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    private class ConfigurationModelsBundleTrackerCustomizer
    implements BundleTrackerCustomizer<ConfigurationModelIterator> {
        private ConfigurationModelsBundleTrackerCustomizer() {
        }

        public ConfigurationModelIterator addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            if (!ConfigurationIndexingExtender.this._clusterMasterExecutor.isMaster()) {
                return null;
            }
            Map<String, ConfigurationModel> configurationModels = ConfigurationIndexingExtender.this._configurationModelRetriever.getConfigurationModels(bundle, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
            if (configurationModels.isEmpty()) {
                return null;
            }
            ConfigurationIndexingExtender.this._configurationModelIndexer.reindex(configurationModels.values());
            ConfigurationIndexingExtender.this.commit((Indexer<ConfigurationModel>)ConfigurationIndexingExtender.this._configurationModelIndexer);
            return new ConfigurationModelIterator(configurationModels.values());
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ConfigurationModelIterator configurationModelIterator) {
            this.removedBundle(bundle, bundleEvent, configurationModelIterator);
            this.addingBundle(bundle, bundleEvent);
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ConfigurationModelIterator configurationModelIterator) {
            if (!ConfigurationIndexingExtender.this._clusterMasterExecutor.isMaster()) {
                return;
            }
            for (ConfigurationModel configurationModel : configurationModelIterator.getResults()) {
                try {
                    ConfigurationIndexingExtender.this._configurationModelIndexer.delete(configurationModel);
                }
                catch (SearchException se) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)"Unable to reindex models", (Throwable)se);
                }
            }
            ConfigurationIndexingExtender.this.commit((Indexer<ConfigurationModel>)ConfigurationIndexingExtender.this._configurationModelIndexer);
        }
    }
}

