/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.portlet.action;

import com.liferay.configuration.admin.display.ConfigurationScreen;
import com.liferay.configuration.admin.web.internal.display.ConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.ConfigurationModelConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.ConfigurationScreenConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.context.ConfigurationScopeDisplayContext;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryIterator;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_InstanceSettingsPortlet", "javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "mvc.command.name=/search"}, service={MVCRenderCommand.class})
public class SearchMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private ConfigurationEntryRetriever _configurationEntryRetriever;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(ConfigurationModel.class);
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(false);
        searchContext.setCompanyId(0L);
        searchContext.setLocale(renderRequest.getLocale());
        String keywords = renderRequest.getParameter("keywords");
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(true);
        queryConfig.setLocale(renderRequest.getLocale());
        queryConfig.setScoreEnabled(true);
        try {
            Hits hits = indexer.search(searchContext);
            Document[] documents = hits.getDocs();
            ConfigurationScopeDisplayContext configurationScopeDisplayContext = new ConfigurationScopeDisplayContext((PortletRequest)renderRequest);
            Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(configurationScopeDisplayContext.getScope(), configurationScopeDisplayContext.getScopePK());
            ArrayList<ConfigurationEntry> searchResults = new ArrayList<ConfigurationEntry>(documents.length);
            for (Document document : documents) {
                String configurationModelId = document.get("configurationModelId");
                ConfigurationModel configurationModel = configurationModels.get(configurationModelId);
                if (configurationModel == null) {
                    String configurationModelFactoryId = document.get("configurationModelFactoryPid");
                    configurationModel = configurationModels.get(configurationModelFactoryId);
                }
                if (configurationModel == null || !configurationModel.isGenerateUI()) continue;
                searchResults.add(new ConfigurationModelConfigurationEntry(configurationModel, renderRequest.getLocale(), this._resourceBundleLoaderProvider));
            }
            ExtendedObjectClassDefinition.Scope scope = configurationScopeDisplayContext.getScope();
            for (ConfigurationScreen configurationScreen : this._configurationEntryRetriever.getAllConfigurationScreens()) {
                if (!scope.equals(configurationScreen.getScope())) continue;
                String configurationScreenKey = StringUtil.toLowerCase((String)configurationScreen.getKey(), (Locale)renderRequest.getLocale());
                String configurationScreenName = StringUtil.toLowerCase((String)configurationScreen.getName(renderRequest.getLocale()), (Locale)renderRequest.getLocale());
                String searchReadyKeywords = StringUtil.toLowerCase((String)keywords, (Locale)renderRequest.getLocale());
                if (!Validator.isNull((String)keywords) && !configurationScreenKey.contains(searchReadyKeywords) && !configurationScreenName.contains(searchReadyKeywords)) continue;
                searchResults.add(new ConfigurationScreenConfigurationEntry(configurationScreen, renderRequest.getLocale()));
            }
            renderRequest.setAttribute("CONFIGURATION_ENTRY_ITERATOR", (Object)new ConfigurationEntryIterator((List<ConfigurationEntry>)searchResults));
            renderRequest.setAttribute("CONFIGURATION_ENTRY_RETRIEVER", (Object)this._configurationEntryRetriever);
            renderRequest.setAttribute("RESOURCE_BUNDLE_LOADER_PROVIDER", (Object)this._resourceBundleLoaderProvider);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return "/search_results.jsp";
    }
}

