/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.portlet.action;

import com.liferay.configuration.admin.web.internal.exporter.ConfigurationExporter;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.AttributeDefinitionUtil;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedAttributeDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.cm.Configuration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.AttributeDefinition;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "mvc.command.name=export"}, service={MVCResourceCommand.class})
public class ExportConfigurationMVCResourceCommand
implements MVCResourceCommand {
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;

    public boolean serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        String pid = ParamUtil.getString((PortletRequest)resourceRequest, (String)"pid");
        String factoryPid = ParamUtil.getString((PortletRequest)resourceRequest, (String)"factoryPid");
        try {
            if (Validator.isNotNull((String)pid)) {
                this.exportPid(resourceRequest, resourceResponse);
            } else if (Validator.isNotNull((String)factoryPid)) {
                this.exportFactoryPid(resourceRequest, resourceResponse);
            } else {
                this.exportAll(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return false;
    }

    protected void exportAll(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = themeDisplay.getLanguageId();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(themeDisplay.getLanguageId(), ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        for (ConfigurationModel configurationModel : configurationModels.values()) {
            if (configurationModel.isFactory()) {
                String curFactoryPid = configurationModel.getFactoryPid();
                List<ConfigurationModel> factoryInstances = this._configurationModelRetriever.getFactoryInstances(configurationModel, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
                for (ConfigurationModel factoryInstance : factoryInstances) {
                    String curPid = factoryInstance.getID();
                    String curFileName = this.getFileName(curFactoryPid, curPid);
                    zipWriter.addEntry(curFileName, ConfigurationExporter.getPropertiesAsBytes(this.getProperties(languageId, curFactoryPid, curPid)));
                }
                continue;
            }
            if (!configurationModel.hasConfiguration()) continue;
            String curPid = configurationModel.getID();
            String curFileName = this.getFileName(null, curPid);
            zipWriter.addEntry(curFileName, ConfigurationExporter.getPropertiesAsBytes(this.getProperties(languageId, curPid, curPid)));
        }
        String fileName = "liferay-system-settings.zip";
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (InputStream)new FileInputStream(zipWriter.getFile()), (String)"application/zip");
    }

    protected void exportFactoryPid(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = themeDisplay.getLanguageId();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        String factoryPid = ParamUtil.getString((PortletRequest)resourceRequest, (String)"factoryPid");
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(themeDisplay.getLanguageId(), ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        ConfigurationModel factoryConfigurationModel = configurationModels.get(factoryPid);
        List<ConfigurationModel> factoryInstances = this._configurationModelRetriever.getFactoryInstances(factoryConfigurationModel, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        for (ConfigurationModel factoryInstance : factoryInstances) {
            String curPid = factoryInstance.getID();
            String curFileName = this.getFileName(factoryPid, curPid);
            zipWriter.addEntry(curFileName, ConfigurationExporter.getPropertiesAsBytes(this.getProperties(languageId, factoryPid, curPid)));
        }
        String fileName = "liferay-system-settings-" + factoryConfigurationModel.getFactoryPid() + ".zip";
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (InputStream)new FileInputStream(zipWriter.getFile()), (String)"application/zip");
    }

    protected void exportPid(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String factoryPid = ParamUtil.getString((PortletRequest)resourceRequest, (String)"factoryPid");
        String pid = ParamUtil.getString((PortletRequest)resourceRequest, (String)"pid");
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = themeDisplay.getLanguageId();
        String fileName = this.getFileName(factoryPid, pid);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (byte[])ConfigurationExporter.getPropertiesAsBytes(this.getProperties(languageId, factoryPid, pid)), (String)"text/xml; charset=UTF-8");
    }

    protected String getFileName(String factoryPid, String pid) {
        String fileName = pid;
        if (Validator.isNotNull((String)factoryPid) && !factoryPid.equals(pid)) {
            String factoryInstanceId = pid.substring(factoryPid.length() + 1);
            fileName = factoryPid + "-" + factoryInstanceId;
        }
        return fileName + ".config";
    }

    protected Properties getProperties(String languageId, String factoryPid, String pid) throws Exception {
        ExtendedAttributeDefinition[] attributeDefinitions;
        Properties properties = new Properties();
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(languageId, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        ConfigurationModel configurationModel = configurationModels.get(pid);
        if (configurationModel == null && Validator.isNotNull((String)factoryPid)) {
            configurationModel = configurationModels.get(factoryPid);
        }
        if (configurationModel == null) {
            return properties;
        }
        Configuration configuration = this._configurationModelRetriever.getConfiguration(pid, ExtendedObjectClassDefinition.Scope.SYSTEM, null);
        if (configuration == null) {
            return properties;
        }
        ExtendedObjectClassDefinition extendedObjectClassDefinition = configurationModel.getExtendedObjectClassDefinition();
        for (ExtendedAttributeDefinition attributeDefinition : attributeDefinitions = extendedObjectClassDefinition.getAttributeDefinitions(-1)) {
            Object value;
            if (!PropsValues.MODULE_FRAMEWORK_EXPORT_PASSWORD_ATTRIBUTES && attributeDefinition.getType() == 12 || (value = AttributeDefinitionUtil.getPropertyObject((AttributeDefinition)attributeDefinition, configuration)) == null) continue;
            properties.put(attributeDefinition.getID(), value);
        }
        return properties;
    }
}

