/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.model.listener;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import java.io.IOException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public void onAfterRemove(Company company) throws ModelListenerException {
        try {
            this._clean(company);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
        super.onAfterRemove((BaseModel)company);
    }

    private void _clean(Company company) throws Exception {
        String filterString = StringBundler.concat((Object[])new Object[]{"(", ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), "=", company.getCompanyId(), ")"});
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            return;
        }
        for (Configuration configuration : configurations) {
            try {
                configuration.delete();
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
    }
}

