/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.display;

import com.liferay.configuration.admin.web.internal.display.ConfigurationEntry;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class ConfigurationModelConfigurationEntry
implements ConfigurationEntry {
    private final ConfigurationModel _configurationModel;
    private final Locale _locale;
    private final ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public ConfigurationModelConfigurationEntry(ConfigurationModel configurationModel, Locale locale, ResourceBundleLoaderProvider resourceBundleLoaderProvider) {
        this._configurationModel = configurationModel;
        this._locale = locale;
        this._resourceBundleLoaderProvider = resourceBundleLoaderProvider;
    }

    public boolean equals(Object obj) {
        ConfigurationEntry configurationEntry = (ConfigurationEntry)obj;
        return Objects.equals(this.getKey(), configurationEntry.getKey());
    }

    @Override
    public String getCategory() {
        return this._configurationModel.getCategory();
    }

    public ConfigurationModel getConfigurationModel() {
        return this._configurationModel;
    }

    @Override
    public String getEditURL(RenderRequest renderRequest, RenderResponse renderResponse) {
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("factoryPid", this._configurationModel.getFactoryPid());
        if (this._configurationModel.isFactory() && !this._configurationModel.isCompanyFactory()) {
            portletURL.setParameter("mvcRenderCommandName", "/view_factory_instances");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/edit_configuration");
            portletURL.setParameter("pid", this._configurationModel.getID());
        }
        return portletURL.toString();
    }

    @Override
    public String getKey() {
        return this._configurationModel.getID();
    }

    @Override
    public String getName() {
        ResourceBundleLoader curResourceBundleLoader = this._resourceBundleLoaderProvider.getResourceBundleLoader(this._configurationModel.getBundleSymbolicName());
        ResourceBundle curComponentResourceBundle = curResourceBundleLoader.loadResourceBundle(this._locale);
        String curConfigurationModelName = curComponentResourceBundle != null ? LanguageUtil.get((ResourceBundle)curComponentResourceBundle, (String)this._configurationModel.getName()) : this._configurationModel.getName();
        return curConfigurationModelName;
    }

    @Override
    public String getScope() {
        return this._configurationModel.getScope();
    }

    public int hashCode() {
        return Objects.hash(this._configurationModel);
    }
}

