/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.model;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedAttributeDefinition;
import com.liferay.portal.configuration.metatype.definitions.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.cm.Configuration;

public class ConfigurationModel
implements ExtendedObjectClassDefinition {
    public static final String PROPERTY_KEY_COMPANY_ID = "companyId";
    public static final String PROPERTY_VALUE_COMPANY_ID_DEFAULT = "0";
    private final String _bundleLocation;
    private final String _bundleSymbolicName;
    private final Configuration _configuration;
    private final ExtendedObjectClassDefinition _extendedObjectClassDefinition;
    private final boolean _factory;

    public ConfigurationModel(ExtendedObjectClassDefinition extendedObjectClassDefinition, Configuration configuration, String bundleSymbolicName, String bundleLocation, boolean factory) {
        this._extendedObjectClassDefinition = extendedObjectClassDefinition;
        this._configuration = configuration;
        this._bundleSymbolicName = bundleSymbolicName;
        this._bundleLocation = bundleLocation;
        this._factory = factory;
    }

    public boolean equals(Object obj) {
        ConfigurationModel configurationModel = (ConfigurationModel)obj;
        return Objects.equals(this.getID(), configurationModel.getID());
    }

    public ExtendedAttributeDefinition[] getAttributeDefinitions(int filter) {
        ExtendedAttributeDefinition[] extendedAttributeDefinitions = this._extendedObjectClassDefinition.getAttributeDefinitions(filter);
        return this.removeFactoryInstanceLabelAttribute(extendedAttributeDefinitions);
    }

    public String getBundleLocation() {
        return this._bundleLocation;
    }

    public String getBundleSymbolicName() {
        return this._bundleSymbolicName;
    }

    public String getCategory() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return GetterUtil.get((String)((String)extensionAttributes.get("category")), (String)"third-party");
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public String getDescription() {
        return this._extendedObjectClassDefinition.getDescription();
    }

    public String[] getDescriptionArguments() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return StringUtil.split((String)((String)extensionAttributes.get("description-arguments")));
    }

    public ExtendedAttributeDefinition getExtendedAttributeDefinition(String id) {
        ExtendedAttributeDefinition[] extendedAttributeDefinitions;
        for (ExtendedAttributeDefinition extendedAttributeDefinition : extendedAttributeDefinitions = this._extendedObjectClassDefinition.getAttributeDefinitions(-1)) {
            if (!id.equals(extendedAttributeDefinition.getID())) continue;
            return extendedAttributeDefinition;
        }
        return null;
    }

    public ExtendedObjectClassDefinition getExtendedObjectClassDefinition() {
        return this._extendedObjectClassDefinition;
    }

    public Map<String, String> getExtensionAttributes(String uri) {
        return this._extendedObjectClassDefinition.getExtensionAttributes(uri);
    }

    public Set<String> getExtensionUris() {
        return this._extendedObjectClassDefinition.getExtensionUris();
    }

    public String getFactoryPid() {
        return this._extendedObjectClassDefinition.getID();
    }

    public Map<String, String> getHintAttributes() {
        return this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/meta-type-hints_7_0_0");
    }

    public InputStream getIcon(int size) throws IOException {
        return this._extendedObjectClassDefinition.getIcon(size);
    }

    public String getID() {
        if (this._configuration != null) {
            return this._configuration.getPid();
        }
        return this._extendedObjectClassDefinition.getID();
    }

    public String getLabel() {
        String value = this.getLabelAttributeValue();
        if (value == null) {
            return this.getName();
        }
        return value;
    }

    public String getLabelAttribute() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return GetterUtil.get((String)((String)extensionAttributes.get("factoryInstanceLabelAttribute")), (String)"");
    }

    public String getName() {
        return this._extendedObjectClassDefinition.getName();
    }

    public String[] getNameArguments() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return StringUtil.split((String)((String)extensionAttributes.get("name-arguments")));
    }

    public String getScope() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return GetterUtil.get((String)((String)extensionAttributes.get("scope")), (String)ExtendedObjectClassDefinition.Scope.SYSTEM.toString());
    }

    public boolean hasConfiguration() {
        return this.getConfiguration() != null;
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getID());
    }

    public boolean isCompanyFactory() {
        if (!this.isFactory()) {
            return false;
        }
        return Objects.equals(this.getScope(), ExtendedObjectClassDefinition.Scope.COMPANY.toString()) && Objects.equals(this.getLabelAttribute(), PROPERTY_KEY_COMPANY_ID);
    }

    public boolean isCompanyScope() {
        return Objects.equals(this.getScope(), ExtendedObjectClassDefinition.Scope.COMPANY);
    }

    public boolean isFactory() {
        return this._factory;
    }

    public boolean isGenerateUI() {
        Map extensionAttributes = this._extendedObjectClassDefinition.getExtensionAttributes("http://www.liferay.com/xsd/liferay-configuration-admin_1_0_0.xsd");
        return GetterUtil.get((String)((String)extensionAttributes.get("generateUI")), (boolean)true);
    }

    public boolean isGroupScope() {
        return Objects.equals(this.getScope(), ExtendedObjectClassDefinition.Scope.GROUP);
    }

    public boolean isPortletInstanceScope() {
        return Objects.equals(this.getScope(), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE);
    }

    public boolean isSystemScope() {
        return Objects.equals(this.getScope(), ExtendedObjectClassDefinition.Scope.SYSTEM);
    }

    protected String getLabelAttributeValue() {
        String factoryInstanceLabelAttribute = this.getLabelAttribute();
        String value = null;
        if (Validator.isNotNull((String)factoryInstanceLabelAttribute)) {
            Dictionary properties = this._configuration.getProperties();
            Object valueObj = properties.get(factoryInstanceLabelAttribute);
            value = valueObj instanceof Object[] ? StringUtil.merge((Object[])((Object[])valueObj), (String)", ") : String.valueOf(valueObj);
        }
        return value;
    }

    protected ExtendedAttributeDefinition[] removeFactoryInstanceLabelAttribute(ExtendedAttributeDefinition[] extendedAttributeDefinitions) {
        if (!this.isCompanyFactory()) {
            return extendedAttributeDefinitions;
        }
        ArrayList<ExtendedAttributeDefinition> filteredExtendedAttributeDefinitionsList = new ArrayList<ExtendedAttributeDefinition>();
        for (ExtendedAttributeDefinition extendedAttributeDefinition : extendedAttributeDefinitions) {
            String attributeId = extendedAttributeDefinition.getID();
            if (attributeId.equals(this.getLabelAttribute())) continue;
            filteredExtendedAttributeDefinitionsList.add(extendedAttributeDefinition);
        }
        return filteredExtendedAttributeDefinitionsList.toArray(new ExtendedAttributeDefinition[filteredExtendedAttributeDefinitionsList.size()]);
    }
}

