/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.display;

import com.liferay.configuration.admin.web.internal.display.ConfigurationCategoryDisplay;
import com.liferay.configuration.admin.web.internal.display.ConfigurationEntry;
import com.liferay.configuration.admin.web.internal.display.ConfigurationScopeDisplay;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ConfigurationCategoryMenuDisplay {
    private static final String[] _UI_ORDERED_SCOPES = new String[]{ExtendedObjectClassDefinition.Scope.SYSTEM.toString(), ExtendedObjectClassDefinition.Scope.COMPANY.toString(), ExtendedObjectClassDefinition.Scope.GROUP.toString(), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE.toString()};
    private final ConfigurationCategoryDisplay _configurationCategoryDisplay;
    private Map<String, ConfigurationScopeDisplay> _configurationScopeDisplays = new LinkedHashMap<String, ConfigurationScopeDisplay>();

    public ConfigurationCategoryMenuDisplay(ConfigurationCategoryDisplay configurationCategoryDisplay, Set<ConfigurationEntry> configurationEntries) {
        this._configurationCategoryDisplay = configurationCategoryDisplay;
        Stream<String> scopeStream = Arrays.stream(_UI_ORDERED_SCOPES);
        scopeStream.forEach(scopeKey -> this._configurationScopeDisplays.put((String)scopeKey, new ConfigurationScopeDisplay((String)scopeKey)));
        for (ConfigurationEntry configurationEntry : configurationEntries) {
            this._addConfigurationEntry(configurationEntry);
        }
    }

    public ConfigurationCategoryDisplay getConfigurationCategoryDisplay() {
        return this._configurationCategoryDisplay;
    }

    public Collection<ConfigurationScopeDisplay> getConfigurationScopeDisplays() {
        return this._configurationScopeDisplays.values();
    }

    public ConfigurationEntry getFirstConfigurationEntry() {
        for (ConfigurationScopeDisplay configurationScopeDisplay : this._configurationScopeDisplays.values()) {
            List<ConfigurationEntry> configurationEntries = configurationScopeDisplay.getConfigurationEntries();
            if (configurationEntries.isEmpty()) continue;
            return configurationEntries.get(0);
        }
        return null;
    }

    public boolean isEmpty() {
        for (ConfigurationScopeDisplay configurationScopeDisplay : this._configurationScopeDisplays.values()) {
            if (configurationScopeDisplay.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void _addConfigurationEntry(ConfigurationEntry configurationEntry) {
        ConfigurationScopeDisplay configurationScopeDisplay = this._configurationScopeDisplays.get(configurationEntry.getScope());
        if (configurationScopeDisplay == null) {
            configurationScopeDisplay = new ConfigurationScopeDisplay(configurationEntry.getScope());
            this._configurationScopeDisplays.put(configurationEntry.getScope(), configurationScopeDisplay);
        }
        configurationScopeDisplay.add(configurationEntry);
    }
}

