/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.portlet.action;

import com.liferay.configuration.admin.web.internal.display.ConfigurationCategoryMenuDisplay;
import com.liferay.configuration.admin.web.internal.display.ConfigurationModelConfigurationEntry;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelIterator;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "mvc.command.name=/view_factory_instances", "service.ranking:Integer=2147483647"}, service={MVCRenderCommand.class})
public class ViewFactoryInstancesMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private ConfigurationEntryRetriever _configurationEntryRetriever;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private Portal _portal;
    private final Map<String, MVCRenderCommand> _renderCommands = new HashMap<String, MVCRenderCommand>();
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        String factoryPid = ParamUtil.getString((PortletRequest)renderRequest, (String)"factoryPid");
        MVCRenderCommand customRenderCommand = this._renderCommands.get(factoryPid);
        if (customRenderCommand != null) {
            return customRenderCommand.render(renderRequest, renderResponse);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(themeDisplay.getLanguageId());
        try {
            ConfigurationModel factoryConfigurationModel = configurationModels.get(factoryPid);
            ConfigurationCategoryMenuDisplay configurationCategoryMenuDisplay = this._configurationEntryRetriever.getConfigurationCategoryMenuDisplay(factoryConfigurationModel.getCategory(), themeDisplay.getLanguageId());
            renderRequest.setAttribute("CONFIGURATION_CATEGORY_MENU_DISPLAY", (Object)configurationCategoryMenuDisplay);
            List<ConfigurationModel> factoryInstances = this._configurationModelRetriever.getFactoryInstances(factoryConfigurationModel);
            ConfigurationModelConfigurationEntry configurationEntry = new ConfigurationModelConfigurationEntry(factoryConfigurationModel, this._portal.getLocale((PortletRequest)renderRequest), this._resourceBundleLoaderProvider);
            renderRequest.setAttribute("CONFIGURATION_ENTRY", (Object)configurationEntry);
            renderRequest.setAttribute("CONFIGURATION_MODEL_ITERATOR", (Object)new ConfigurationModelIterator(factoryInstances));
            renderRequest.setAttribute("FACTORY_CONFIGURATION_MODEL", (Object)factoryConfigurationModel);
            renderRequest.setAttribute("RESOURCE_BUNDLE_LOADER_PROVIDER", (Object)this._resourceBundleLoaderProvider);
            return "/view_factory_instances.jsp";
        }
        catch (IOException ioe) {
            throw new PortletException((Throwable)ioe);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet)(mvc.command.name=/view_factory_instances)(configurationPid=*))")
    protected void addRenderCommand(MVCRenderCommand mvcRenderCommand, Map<String, Object> properties) {
        this._renderCommands.put((String)properties.get("configurationPid"), mvcRenderCommand);
    }

    protected void removeRenderCommand(MVCRenderCommand mvcRenderCommand, Map<String, Object> properties) {
        this._renderCommands.remove(properties.get("configurationPid"));
    }
}

