/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.portlet.action;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationEntryRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelIterator;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "mvc.command.name=/search"}, service={MVCRenderCommand.class})
public class SearchMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private ConfigurationEntryRetriever _configurationEntryRetriever;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(ConfigurationModel.class);
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(false);
        searchContext.setCompanyId(0L);
        searchContext.setLocale(renderRequest.getLocale());
        String keywords = renderRequest.getParameter("keywords");
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(true);
        queryConfig.setLocale(renderRequest.getLocale());
        queryConfig.setScoreEnabled(true);
        try {
            Hits hits = indexer.search(searchContext);
            Document[] documents = hits.getDocs();
            Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels();
            ArrayList<ConfigurationModel> searchResults = new ArrayList<ConfigurationModel>(documents.length);
            for (Document document : documents) {
                String configurationModelId = document.get("configurationModelId");
                ConfigurationModel configurationModel = configurationModels.get(configurationModelId);
                if (configurationModel == null) {
                    String configurationModelFactoryId = document.get("configurationModelFactoryPid");
                    configurationModel = configurationModels.get(configurationModelFactoryId);
                }
                if (configurationModel == null) continue;
                searchResults.add(configurationModel);
            }
            ConfigurationModelIterator configurationModelIterator = new ConfigurationModelIterator((List<ConfigurationModel>)searchResults);
            renderRequest.setAttribute("CONFIGURATION_ENTRY_RETRIEVER", (Object)this._configurationEntryRetriever);
            renderRequest.setAttribute("CONFIGURATION_MODEL_ITERATOR", (Object)configurationModelIterator);
            renderRequest.setAttribute("RESOURCE_BUNDLE_LOADER_PROVIDER", (Object)this._resourceBundleLoaderProvider);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return "/search_results.jsp";
    }
}

