/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.portlet.action;

import com.liferay.configuration.admin.display.ConfigurationFormRenderer;
import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationFormRendererRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelRetriever;
import com.liferay.configuration.admin.web.internal.util.ConfigurationModelToDDMFormConverter;
import com.liferay.configuration.admin.web.internal.util.DDMFormValuesToPropertiesConverter;
import com.liferay.configuration.admin.web.internal.util.ResourceBundleLoaderProvider;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet", "mvc.command.name=bindConfiguration"}, service={MVCActionCommand.class})
public class BindConfigurationMVCActionCommand
implements MVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(BindConfigurationMVCActionCommand.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationFormRendererRetriever _configurationFormRendererRetriever;
    @Reference
    private ConfigurationModelRetriever _configurationModelRetriever;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceBundleLoaderProvider _resourceBundleLoaderProvider;

    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String factoryPid = ParamUtil.getString((PortletRequest)actionRequest, (String)"factoryPid");
        String pid = ParamUtil.getString((PortletRequest)actionRequest, (String)"pid", (String)factoryPid);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Binding attributes for service " + pid));
        }
        ConfigurationModel configurationModel = null;
        Map<String, ConfigurationModel> configurationModels = this._configurationModelRetriever.getConfigurationModels(themeDisplay.getLanguageId());
        configurationModel = Validator.isNotNull((String)factoryPid) ? configurationModels.get(factoryPid) : configurationModels.get(pid);
        Configuration configuration = this._configurationModelRetriever.getConfiguration(pid);
        ResourceBundleLoader resourceBundleLoader = this._resourceBundleLoaderProvider.getResourceBundleLoader(configurationModel.getBundleSymbolicName());
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(themeDisplay.getLocale());
        Dictionary<String, Object> properties = null;
        Map<String, Object> requestParameters = this.getRequestParameters(actionRequest, pid);
        properties = requestParameters != null ? this.toDictionary(requestParameters) : this.getDDMRequestParameters(actionRequest, configurationModel, resourceBundle);
        properties.put("service.pid", pid);
        if (Validator.isNotNull((String)factoryPid)) {
            properties.put("service.factoryPid", factoryPid);
        }
        try {
            this.configureTargetService(configurationModel, configuration, properties);
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (ConfigurationModelListenerException cmle) {
            SessionErrors.add((PortletRequest)actionRequest, ConfigurationModelListenerException.class, (Object)((Object)cmle));
            actionResponse.setRenderParameter("mvcRenderCommandName", "/edit_configuration");
        }
        catch (IOException ioe) {
            throw new PortletException((Throwable)ioe);
        }
        return true;
    }

    protected void configureTargetService(ConfigurationModel configurationModel, Configuration configuration, Dictionary<String, Object> properties) throws ConfigurationModelListenerException, PortletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Properties: " + properties));
        }
        try {
            Hashtable<String, Object> configuredProperties;
            block18: {
                if (configuration == null) {
                    if (configurationModel.isFactory()) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Creating factory PID");
                        }
                        configuration = this._configurationAdmin.createFactoryConfiguration(configurationModel.getID(), "?");
                    } else {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Creating instance PID");
                        }
                        configuration = this._configurationAdmin.getConfiguration(configurationModel.getID(), "?");
                    }
                }
                if ((configuredProperties = configuration.getProperties()) == null) {
                    configuredProperties = new Hashtable<String, Object>();
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Configuration properties: " + configuration.getProperties()));
                }
                Enumeration<String> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    Object value = properties.get(key);
                    ((Dictionary)configuredProperties).put(key, value);
                }
                if (configurationModel.isCompanyFactory()) {
                    ((Dictionary)configuredProperties).put("companyId", "0");
                }
                if (configurationModel.isFactory()) {
                    ((Dictionary)configuredProperties).put("configuration.cleaner.ignore", "true");
                    String pid = configuration.getPid();
                    int index = pid.lastIndexOf(46);
                    String factoryPid = pid.substring(index + 1);
                    StringBundler sb = new StringBundler(4);
                    sb.append(configuration.getFactoryPid());
                    sb.append("-");
                    sb.append(factoryPid);
                    sb.append(".config");
                    File file = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, sb.toString());
                    file = file.getAbsoluteFile();
                    URI uri = file.toURI();
                    String fileName = uri.toString();
                    String oldFileName = ((Dictionary)configuredProperties).put("felix.fileinstall.filename", fileName);
                    if (oldFileName != null && !oldFileName.equals(fileName)) {
                        try {
                            Path oldFilePath = Paths.get(new URI(oldFileName));
                            Files.deleteIfExists(oldFilePath);
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Delete inconsistent factory configuration " + oldFileName));
                            }
                        }
                        catch (Exception e) {
                            if (!_log.isWarnEnabled()) break block18;
                            _log.warn((Object)("Unable to delete inconsistent factory configuration " + oldFileName), (Throwable)e);
                        }
                    }
                }
            }
            configuration.update(configuredProperties);
        }
        catch (ConfigurationModelListenerException cmle) {
            throw cmle;
        }
        catch (IOException ioe) {
            throw new PortletException((Throwable)ioe);
        }
    }

    protected DDMFormValues getDDMFormValues(ActionRequest actionRequest, DDMForm ddmForm) {
        return this._ddmFormValuesFactory.create((PortletRequest)actionRequest, ddmForm);
    }

    protected Dictionary<String, Object> getDDMRequestParameters(ActionRequest actionRequest, ConfigurationModel configurationModel, ResourceBundle resourceBundle) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ConfigurationModelToDDMFormConverter configurationModelToDDMFormConverter = new ConfigurationModelToDDMFormConverter(configurationModel, themeDisplay.getLocale(), resourceBundle);
        DDMForm ddmForm = configurationModelToDDMFormConverter.getDDMForm();
        DDMFormValues ddmFormValues = this.getDDMFormValues(actionRequest, ddmForm);
        DDMFormValuesToPropertiesConverter ddmFormValuesToPropertiesConverter = new DDMFormValuesToPropertiesConverter(configurationModel, ddmFormValues, this._jsonFactory, themeDisplay.getLocale());
        return ddmFormValuesToPropertiesConverter.getProperties();
    }

    protected Map<String, Object> getRequestParameters(ActionRequest actionRequest, String pid) {
        ConfigurationFormRenderer configurationFormRenderer = this._configurationFormRendererRetriever.getConfigurationFormRenderer(pid);
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        return configurationFormRenderer.getRequestParameters(request);
    }

    protected Dictionary<String, Object> toDictionary(Map<String, Object> requestParameters) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> entry : requestParameters.entrySet()) {
            ((Dictionary)properties).put(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

