/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.configuration.admin.web.internal.util;

import com.liferay.configuration.admin.web.internal.model.ConfigurationModel;
import com.liferay.configuration.admin.web.internal.util.ConfigurationDDMFormDeclarationUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.configuration.metatype.definitions.ExtendedAttributeDefinition;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.metatype.AttributeDefinition;

public class ConfigurationModelToDDMFormConverter {
    private final ConfigurationModel _configurationModel;
    private final Locale _locale;
    private final ResourceBundle _resourceBundle;

    public ConfigurationModelToDDMFormConverter(ConfigurationModel configurationModel, Locale locale, ResourceBundle resourceBundle) {
        this._configurationModel = configurationModel;
        this._locale = locale;
        this._resourceBundle = resourceBundle;
    }

    public DDMForm getDDMForm() {
        DDMForm ddmForm = this.getConfigurationDDMForm();
        if (ddmForm == null) {
            ddmForm = new DDMForm();
        }
        ddmForm.addAvailableLocale(this._locale);
        ddmForm.setDefaultLocale(this._locale);
        this.addRequiredDDMFormFields(ddmForm);
        this.addOptionalDDMFormFields(ddmForm);
        return ddmForm;
    }

    protected void addDDMFormFields(AttributeDefinition[] attributeDefinitions, DDMForm ddmForm, boolean required) {
        if (attributeDefinitions == null) {
            return;
        }
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            if (ddmFormFieldsMap.containsKey(attributeDefinition.getID())) continue;
            DDMFormField ddmFormField = this.getDDMFormField(attributeDefinition, required);
            ddmForm.addDDMFormField(ddmFormField);
        }
    }

    protected void addOptionalDDMFormFields(DDMForm ddmForm) {
        ExtendedAttributeDefinition[] optionalAttributeDefinitions = this._configurationModel.getAttributeDefinitions(2);
        this.addDDMFormFields((AttributeDefinition[])optionalAttributeDefinitions, ddmForm, false);
    }

    protected void addRequiredDDMFormFields(DDMForm ddmForm) {
        ExtendedAttributeDefinition[] requiredAttributeDefinitions = this._configurationModel.getAttributeDefinitions(1);
        this.addDDMFormFields((AttributeDefinition[])requiredAttributeDefinitions, ddmForm, true);
    }

    protected DDMForm getConfigurationDDMForm() {
        Class<?> formClass = ConfigurationDDMFormDeclarationUtil.getConfigurationDDMFormClass(this._configurationModel);
        if (formClass != null) {
            try {
                return DDMFormFactory.create(formClass);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    protected DDMFormFieldOptions getDDMFieldOptions(AttributeDefinition attributeDefinition) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        String[] optionLabels = attributeDefinition.getOptionLabels();
        String[] optionValues = attributeDefinition.getOptionValues();
        if (optionLabels == null || optionValues == null) {
            return ddmFormFieldOptions;
        }
        for (int i = 0; i < optionLabels.length; ++i) {
            ddmFormFieldOptions.addOptionLabel(optionValues[i], this._locale, this.translate(optionLabels[i]));
        }
        return ddmFormFieldOptions;
    }

    protected DDMFormField getDDMFormField(AttributeDefinition attributeDefinition, boolean required) {
        String type = this.getDDMFormFieldType(attributeDefinition);
        DDMFormField ddmFormField = new DDMFormField(attributeDefinition.getID(), type);
        this.setDDMFormFieldDataType(attributeDefinition, ddmFormField);
        this.setDDMFormFieldLabel(attributeDefinition, ddmFormField);
        this.setDDMFormFieldOptions(attributeDefinition, ddmFormField);
        this.setDDMFormFieldPredefinedValue(attributeDefinition, ddmFormField);
        this.setDDMFormFieldRequired(attributeDefinition, ddmFormField, required);
        this.setDDMFormFieldTip(attributeDefinition, ddmFormField);
        ddmFormField.setLocalizable(true);
        ddmFormField.setShowLabel(true);
        this.setDDMFormFieldRepeatable(attributeDefinition, ddmFormField);
        this.setDDMFormFieldDisplayStyle(ddmFormField);
        return ddmFormField;
    }

    protected String getDDMFormFieldDataType(AttributeDefinition attributeDefinition) {
        int type = attributeDefinition.getType();
        if (type == 11) {
            return "boolean";
        }
        if (type == 7) {
            return "double";
        }
        if (type == 8) {
            return "float";
        }
        if (type == 3) {
            return "integer";
        }
        if (type == 2) {
            return "long";
        }
        if (type == 4) {
            return "short";
        }
        return "string";
    }

    protected String getDDMFormFieldPredefinedValue(AttributeDefinition attributeDefinition) {
        String dataType = this.getDDMFormFieldDataType(attributeDefinition);
        if (dataType.equals("boolean")) {
            return "false";
        }
        if (dataType.equals("double") || dataType.equals("float")) {
            return "0.0";
        }
        if (dataType.equals("integer") || dataType.equals("long") || dataType.equals("short")) {
            return "0";
        }
        return "";
    }

    protected String getDDMFormFieldType(AttributeDefinition attributeDefinition) {
        int type = attributeDefinition.getType();
        if (type == 11) {
            Object[] optionLabels = attributeDefinition.getOptionLabels();
            if (ArrayUtil.isEmpty((Object[])optionLabels)) {
                return "checkbox";
            }
            return "radio";
        }
        if (type == 12) {
            return "password";
        }
        if (ArrayUtil.isNotEmpty((Object[])attributeDefinition.getOptionLabels()) || ArrayUtil.isNotEmpty((Object[])attributeDefinition.getOptionValues())) {
            return "select";
        }
        return "text";
    }

    protected void setDDMFormFieldDataType(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        String dataType = this.getDDMFormFieldDataType(attributeDefinition);
        ddmFormField.setDataType(dataType);
    }

    protected void setDDMFormFieldDisplayStyle(DDMFormField ddmFormField) {
        String dataType = ddmFormField.getDataType();
        if (Objects.equals(dataType, "string")) {
            ddmFormField.setProperty("displayStyle", (Object)"multiline");
        }
    }

    protected void setDDMFormFieldLabel(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        LocalizedValue label = new LocalizedValue(this._locale);
        label.addString(this._locale, this.translate(attributeDefinition.getName()));
        ddmFormField.setLabel(label);
    }

    protected void setDDMFormFieldOptions(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        DDMFormFieldOptions ddmFormFieldOptions = this.getDDMFieldOptions(attributeDefinition);
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
    }

    protected void setDDMFormFieldPredefinedValue(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        String type = ddmFormField.getType();
        String predefinedValueString = this.getDDMFormFieldPredefinedValue(attributeDefinition);
        if (type.equals("select")) {
            predefinedValueString = "[\"" + predefinedValueString + "\"]";
        }
        LocalizedValue predefinedValue = new LocalizedValue(this._locale);
        predefinedValue.addString(this._locale, predefinedValueString);
        ddmFormField.setPredefinedValue(predefinedValue);
    }

    protected void setDDMFormFieldRepeatable(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        if (attributeDefinition.getCardinality() == 0) {
            return;
        }
        ddmFormField.setRepeatable(true);
    }

    protected void setDDMFormFieldRequired(AttributeDefinition attributeDefinition, DDMFormField ddmFormField, boolean required) {
        if ("checkbox".equals(ddmFormField.getType())) {
            return;
        }
        ddmFormField.setRequired(required);
    }

    protected void setDDMFormFieldTip(AttributeDefinition attributeDefinition, DDMFormField ddmFormField) {
        LocalizedValue tip = new LocalizedValue(this._locale);
        tip.addString(this._locale, this.translate(attributeDefinition.getDescription()));
        ddmFormField.setTip(tip);
    }

    protected String translate(String key) {
        if (this._resourceBundle == null || key == null) {
            return key;
        }
        String value = LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)key);
        if (value == null) {
            return key;
        }
        return value;
    }
}

