/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.comment.constants.CommentConstants;
import com.liferay.comment.web.internal.asset.model.CommentAssetRenderer;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.WorkflowableComment;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_comment_web_portlet_CommentPortlet"}, service={AssetRendererFactory.class})
public class CommentAssetRendererFactory
extends BaseAssetRendererFactory<WorkflowableComment> {
    public static final String TYPE = "discussion";
    private static final boolean _SELECTABLE = false;
    @Reference
    private CommentManager _commentManager;
    @Reference(target="(osgi.web.symbolicname=com.liferay.comment.web)")
    private ServletContext _servletContext;

    public CommentAssetRendererFactory() {
        this.setCategorizable(false);
        this.setClassName(CommentConstants.getDiscussionClassName());
        this.setLinkable(true);
        this.setPortletId("com_liferay_comment_web_portlet_CommentPortlet");
    }

    public AssetRenderer<WorkflowableComment> getAssetRenderer(long classPK, int type) throws PortalException {
        Comment comment = this._commentManager.fetchComment(classPK);
        if (!(comment instanceof WorkflowableComment)) {
            return null;
        }
        WorkflowableComment workflowableComment = (WorkflowableComment)comment;
        CommentAssetRenderer commentAssetRenderer = new CommentAssetRenderer(workflowableComment, (AssetRendererFactory<WorkflowableComment>)this);
        commentAssetRenderer.setAssetRendererType(type);
        commentAssetRenderer.setServletContext(this._servletContext);
        return commentAssetRenderer;
    }

    public String getIconCssClass() {
        return "comments";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_comment_web_portlet_CommentPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(permissionChecker);
        return discussionPermission.hasPermission(classPK, actionId);
    }

    public boolean isSelectable() {
        return false;
    }
}

