/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.web.internal.jsonws;

import com.liferay.comment.web.internal.jsonws.CommentJSONWS;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionCommentIterator;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@AccessControlled
@JSONWebService
@Component(immediate=true, property={"json.web.service.context.name=comment", "json.web.service.context.path=Comment"}, service={CommentManagerJSONWS.class})
public class CommentManagerJSONWS
extends BaseServiceImpl {
    private CommentManager _commentManager;
    private GroupLocalService _groupLocalService;

    public long addComment(long groupId, String className, long classPK, String body) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        long companyId = this.getCompanyId(groupId);
        discussionPermission.checkAddPermission(companyId, groupId, className, classPK);
        return this._commentManager.addComment(this.getUserId(), groupId, className, classPK, body, this.createServiceContextFunction(companyId));
    }

    public void deleteComment(long commentId) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkDeletePermission(commentId);
        this._commentManager.deleteComment(commentId);
    }

    public List<CommentJSONWS> getComments(long commentId, int start, int end) throws PortalException {
        DiscussionComment discussionComment = this._commentManager.fetchDiscussionComment(this.getUserId(), commentId);
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkViewPermission(this.getCompanyId(discussionComment.getGroupId()), discussionComment.getGroupId(), discussionComment.getClassName(), discussionComment.getClassPK());
        return this.getComments(discussionComment, start, end);
    }

    public List<CommentJSONWS> getComments(long groupId, String className, long classPK, int start, int end) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkViewPermission(this.getCompanyId(groupId), groupId, className, classPK);
        Discussion discussion = this._commentManager.getDiscussion(this.getUserId(), groupId, className, classPK, this.createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this.getComments(rootDiscussionComment, start, end);
    }

    public int getCommentsCount(long groupId, String className, long classPK) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkViewPermission(this.getCompanyId(groupId), groupId, className, classPK);
        return this._commentManager.getCommentsCount(className, classPK);
    }

    public boolean hasDiscussion(long groupId, String className, long classPK) throws PortalException {
        BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)className, (long)classPK, (String)"VIEW");
        return this._commentManager.hasDiscussion(className, classPK);
    }

    public void subscribeDiscussion(long groupId, String className, long classPK) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkSubscribePermission(this.getCompanyId(groupId), groupId, className, classPK);
        this._commentManager.subscribeDiscussion(this.getUserId(), groupId, className, classPK);
    }

    public void unsubscribeDiscussion(long groupId, String className, long classPK) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkSubscribePermission(this.getCompanyId(groupId), groupId, className, classPK);
        this._commentManager.unsubscribeDiscussion(this.getUserId(), className, classPK);
    }

    public long updateComment(String className, long classPK, long commentId, String subject, String body) throws PortalException {
        DiscussionPermission discussionPermission = this._commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkUpdatePermission(commentId);
        return this._commentManager.updateComment(this.getUserId(), className, classPK, commentId, subject, body, this.createServiceContextFunction(1));
    }

    protected Function<String, ServiceContext> createServiceContextFunction() {
        return new Function<String, ServiceContext>(){

            public ServiceContext apply(String className) {
                return new ServiceContext();
            }
        };
    }

    protected Function<String, ServiceContext> createServiceContextFunction(final int workflowAction) {
        return new Function<String, ServiceContext>(){

            public ServiceContext apply(String className) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setWorkflowAction(workflowAction);
                return serviceContext;
            }
        };
    }

    protected Function<String, ServiceContext> createServiceContextFunction(final long companyId) {
        return new Function<String, ServiceContext>(){

            public ServiceContext apply(String className) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(companyId);
                return serviceContext;
            }
        };
    }

    protected List<CommentJSONWS> getAllComments(DiscussionCommentIterator threadDiscussionCommentIterator) {
        ArrayList<CommentJSONWS> commentJSONWSs = new ArrayList<CommentJSONWS>();
        while (threadDiscussionCommentIterator.hasNext()) {
            CommentJSONWS commentJSONWS = new CommentJSONWS((DiscussionComment)threadDiscussionCommentIterator.next());
            commentJSONWSs.add(commentJSONWS);
        }
        return commentJSONWSs;
    }

    protected List<CommentJSONWS> getComments(DiscussionComment discussionComment, int start, int end) {
        if (start == -1) {
            start = 0;
        }
        DiscussionCommentIterator threadDiscussionCommentIterator = discussionComment.getThreadDiscussionCommentIterator(start);
        if (end == -1) {
            return this.getAllComments(threadDiscussionCommentIterator);
        }
        int commentsCount = end - start;
        if (commentsCount <= 0) {
            return Collections.emptyList();
        }
        ArrayList<CommentJSONWS> commentJSONWSs = new ArrayList<CommentJSONWS>(commentsCount);
        while (threadDiscussionCommentIterator.hasNext() && commentsCount > 0) {
            CommentJSONWS commentJSONWS = new CommentJSONWS((DiscussionComment)threadDiscussionCommentIterator.next());
            commentJSONWSs.add(commentJSONWS);
            --commentsCount;
        }
        return commentJSONWSs;
    }

    protected long getCompanyId(long groupId) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        return group.getCompanyId();
    }

    protected String getUserName() throws PortalException {
        User user = this.getUser();
        return user.getFullName();
    }

    @Reference(unbind="-")
    protected void setCommentManager(CommentManager commentManager) {
        this._commentManager = commentManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

