/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.web.internal.notifications;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_comment_web_portlet_CommentPortlet"}, service={UserNotificationHandler.class})
public class CommentUserNotificationHandler
extends BaseModelUserNotificationHandler {
    private static final Log _log = LogFactoryUtil.getLog(CommentUserNotificationHandler.class);
    private MBDiscussionLocalService _mbDiscussionLocalService;
    @Reference
    private Portal _portal;

    public CommentUserNotificationHandler() {
        this.setPortletId("com_liferay_comment_web_portlet_CommentPortlet");
    }

    protected MBDiscussion fetchDiscussion(JSONObject jsonObject) {
        long classPK = jsonObject.getLong("classPK");
        try {
            return this._mbDiscussionLocalService.fetchDiscussion(classPK);
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)se, (Throwable)se);
            }
            return null;
        }
    }

    protected AssetRenderer getAssetRenderer(JSONObject jsonObject) {
        MBDiscussion mbDiscussion = this.fetchDiscussion(jsonObject);
        if (mbDiscussion == null) {
            return null;
        }
        return this.getAssetRenderer(mbDiscussion.getClassName(), mbDiscussion.getClassPK());
    }

    protected String getBodyContent(JSONObject jsonObject) {
        return HtmlUtil.stripHtml((String)super.getBodyContent(jsonObject));
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer assetRenderer, ServiceContext serviceContext) {
        MBDiscussion mbDiscussion = this.fetchDiscussion(jsonObject);
        if (mbDiscussion == null) {
            return null;
        }
        String message = "";
        int notificationType = jsonObject.getInt("notificationType");
        if (notificationType == 0) {
            message = assetRenderer != null ? "x-added-a-new-comment-to-x" : "x-added-a-new-comment";
        } else if (notificationType == 1) {
            message = assetRenderer != null ? "x-updated-a-comment-to-x" : "x-updated-a-comment";
        }
        message = assetRenderer != null ? LanguageUtil.format((Locale)serviceContext.getLocale(), (String)message, (Object[])new String[]{HtmlUtil.escape((String)this._portal.getUserName(jsonObject.getLong("userId"), "")), HtmlUtil.escape((String)assetRenderer.getTitle(serviceContext.getLocale()))}, (boolean)false) : LanguageUtil.format((Locale)serviceContext.getLocale(), (String)message, (Object[])new String[]{HtmlUtil.escape((String)this._portal.getUserName(jsonObject.getLong("userId"), ""))}, (boolean)false);
        return message;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }
}

