/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.WorkflowableComment;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommentAssetRenderer
extends BaseJSPAssetRenderer<WorkflowableComment>
implements TrashRenderer {
    private final AssetRendererFactory<WorkflowableComment> _assetRendererFactory;
    private final WorkflowableComment _workflowableComment;

    public CommentAssetRenderer(WorkflowableComment workflowableComment, AssetRendererFactory<WorkflowableComment> assetRendererFactory) {
        this._workflowableComment = workflowableComment;
        this._assetRendererFactory = assetRendererFactory;
    }

    public WorkflowableComment getAssetObject() {
        return this._workflowableComment;
    }

    public AssetRendererFactory<WorkflowableComment> getAssetRendererFactory() {
        return this._assetRendererFactory;
    }

    public String getClassName() {
        return this._workflowableComment.getModelClassName();
    }

    public long getClassPK() {
        return this._workflowableComment.getCommentId();
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._workflowableComment.getModifiedDate();
    }

    public long getGroupId() {
        return this._workflowableComment.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/asset/discussion_" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory<WorkflowableComment> assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSearchSummary(Locale locale) {
        return HtmlUtil.extractText((String)this._workflowableComment.getTranslatedBody(""));
    }

    public int getStatus() {
        return this._workflowableComment.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._workflowableComment.getBody();
    }

    public String getTitle(Locale locale) {
        return StringUtil.shorten((String)this.getSearchSummary(locale));
    }

    public String getType() {
        return "discussion";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._workflowableComment.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_comment_web_portlet_CommentPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/discussion/edit_discussion");
        portletURL.setParameter("commentId", String.valueOf(this._workflowableComment.getCommentId()));
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory<WorkflowableComment> assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcPath", "/view_comment.jsp");
        portletURL.setParameter("commentId", String.valueOf(this._workflowableComment.getCommentId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return null;
    }

    public long getUserId() {
        return this._workflowableComment.getUserId();
    }

    public String getUserName() {
        return this._workflowableComment.getUserName();
    }

    public String getUuid() {
        return this._workflowableComment.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        DiscussionPermission discussionPermission = CommentManagerUtil.getDiscussionPermission((PermissionChecker)permissionChecker);
        return discussionPermission.hasUpdatePermission(this._workflowableComment.getCommentId());
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        DiscussionPermission discussionPermission = CommentManagerUtil.getDiscussionPermission((PermissionChecker)permissionChecker);
        return discussionPermission.hasPermission((Comment)this._workflowableComment, "VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        Comment comment = CommentManagerUtil.fetchComment((long)this._workflowableComment.getCommentId());
        request.setAttribute("COMMENT", (Object)comment);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return true;
    }
}

